/**
 * <copyright> </copyright>
 * 
 * $Id: CompositeImpl.java,v 1.2 2006-04-05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WireSource;
import org.eclipse.stp.core.sca.WireTarget;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Composite</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.CompositeImpl#getEntryPoints <em>Entry Points</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.CompositeImpl#getComponentsGroup <em>Components Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.CompositeImpl#getComponents <em>Components</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.CompositeImpl#getExternalServices <em>External Services</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.CompositeImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class CompositeImpl extends SCAInternalObjectImpl implements Composite {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright        = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getEntryPoints() <em>Entry Points</em>}'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getEntryPoints()
    * @generated
    * @ordered
    */
   protected EList               entryPoints      = null;

   /**
    * The cached value of the '{@link #getComponentsGroup() <em>Components Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getComponentsGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap          componentsGroup  = null;

   /**
    * The cached value of the '{@link #getExternalServices() <em>External Services</em>}'
    * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getExternalServices()
    * @generated
    * @ordered
    */
   protected EList               externalServices = null;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String NAME_EDEFAULT    = null;

   private static final String   URI_SCHEME_SEP   = "://";                                                                                                //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String              name             = NAME_EDEFAULT;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected CompositeImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getComposite();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getEntryPoints() {
      if (entryPoints == null) {
         entryPoints = new EObjectContainmentEList(EntryPoint.class, this,
               SCAPackage.COMPOSITE__ENTRY_POINTS);
      }
      return entryPoints;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getComponentsGroup() {
      if (componentsGroup == null) {
         componentsGroup = new BasicFeatureMap(this,
               SCAPackage.COMPOSITE__COMPONENTS_GROUP);
      }
      return componentsGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getExternalServices() {
      if (externalServices == null) {
         externalServices = new EObjectContainmentEList(ExternalService.class,
               this, SCAPackage.COMPOSITE__EXTERNAL_SERVICES);
      }
      return externalServices;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getComponentsGen() {
      return ((FeatureMap) getComponentsGroup()).list(SCAPackage.eINSTANCE
            .getComposite_Components());
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getName() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setName(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.COMPOSITE__NAME, oldName, name));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.COMPOSITE__ENTRY_POINTS:
               return ((InternalEList) getEntryPoints()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.COMPOSITE__COMPONENTS_GROUP:
               return ((InternalEList) getComponentsGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.COMPOSITE__COMPONENTS:
               return ((InternalEList) getComponents()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.COMPOSITE__EXTERNAL_SERVICES:
               return ((InternalEList) getExternalServices()).basicRemove(
                     otherEnd, msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPOSITE__ENTRY_POINTS:
            return getEntryPoints();
         case SCAPackage.COMPOSITE__COMPONENTS_GROUP:
            return getComponentsGroup();
         case SCAPackage.COMPOSITE__COMPONENTS:
            return getComponents();
         case SCAPackage.COMPOSITE__EXTERNAL_SERVICES:
            return getExternalServices();
         case SCAPackage.COMPOSITE__NAME:
            return getName();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPOSITE__ENTRY_POINTS:
            getEntryPoints().clear();
            getEntryPoints().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPOSITE__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            getComponentsGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPOSITE__COMPONENTS:
            getComponents().clear();
            getComponents().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPOSITE__EXTERNAL_SERVICES:
            getExternalServices().clear();
            getExternalServices().addAll((Collection) newValue);
            return;
         case SCAPackage.COMPOSITE__NAME:
            setName((String) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPOSITE__ENTRY_POINTS:
            getEntryPoints().clear();
            return;
         case SCAPackage.COMPOSITE__COMPONENTS_GROUP:
            getComponentsGroup().clear();
            return;
         case SCAPackage.COMPOSITE__COMPONENTS:
            getComponents().clear();
            return;
         case SCAPackage.COMPOSITE__EXTERNAL_SERVICES:
            getExternalServices().clear();
            return;
         case SCAPackage.COMPOSITE__NAME:
            setName(NAME_EDEFAULT);
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.COMPOSITE__ENTRY_POINTS:
            return entryPoints != null && !entryPoints.isEmpty();
         case SCAPackage.COMPOSITE__COMPONENTS_GROUP:
            return componentsGroup != null && !componentsGroup.isEmpty();
         case SCAPackage.COMPOSITE__COMPONENTS:
            return !getComponents().isEmpty();
         case SCAPackage.COMPOSITE__EXTERNAL_SERVICES:
            return externalServices != null && !externalServices.isEmpty();
         case SCAPackage.COMPOSITE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (componentsGroup: "); //$NON-NLS-1$
      result.append(componentsGroup);
      result.append(", name: "); //$NON-NLS-1$
      result.append(name);
      result.append(')');
      return result.toString();
   }

   /* ********* Custom API ************* */

   public Component getComponent(String componentName) {
      Assert.isNotNullOrEmtpy(componentName, null);
      // TODO Implement a search via an index.
      Component component = null;
      List comps = getComponents();
      if (!comps.isEmpty()) {
         int size = comps.size();
         for (int i = 0; i < size; i++) {
            component = (Component) comps.get(i);
            if (componentName.equals(component.getName()))
               break;
            component = null;
         }
      }
      return component;
   }

   /* ********* Custom API ************* */

   public List getAllMatchingTargets(WireSource wireSource) {
      // TODO Auto-generated method stub
      return null;
   }

   public List getAllMatchingSources(WireTarget wireTarget) {
      // TODO Auto-generated method stub
      return null;
   }

   public ExternalService getExternalService(String name) {
      Assert.isNotNullOrEmtpy(name, null);
      ExternalService extService = null;
      // TODO Implement a search via an index.
      List extServices = getExternalServices();
      if (!extServices.isEmpty()) {
         int size = extServices.size();
         for (int i = 0; i < size; i++) {
            extService = (ExternalService) extServices.get(i);
            if (name.equals(extService.getName()))
               break;
            extService = null;
         }
      }
      return extService;
   }

   public WireTarget resolveWireTarget(String targetURI) {
      Assert.isNotNullOrEmtpy(targetURI, null);
      WireTarget target = null;
      // Test for simple external binding first.
      if (targetURI.indexOf(URI_SCHEME_SEP) > 0) {
         // TODO Add error condition since this is not allowed at the composite
         // level.
      } else {
         int sepIndex = targetURI.indexOf(IConstants.WIRE_PATH_SEP);
         if (sepIndex > 0) {
            // This must be a component with a service designation.
            String componentName = targetURI.substring(0, sepIndex);
            String serviceName = targetURI.substring(sepIndex + 1);
            target = resolveTargetForComponentService(componentName,
                  serviceName);
         } else {
            /*
             * The target uri must be an ExternalService or a Component with a
             * single service.
             */
            target = getExternalService(targetURI);
            if (target == null)
               target = resolveTargetComponentWithSingleService(targetURI);
         }
      }
      if (target == null)
         target = createUnresolvedWireHandle(targetURI);
      return target;
   }

   /*
    * Resolve a WireTarget for a Component with only a single service available.
    * If there are multiple services on the Component or the component fails to
    * resolve then we have an error condition.
    */
   private WireTarget resolveTargetComponentWithSingleService(String name) {
      WireTarget target = null;
      Component component = getComponent(name);

      if (component == null) {
         // TODO set error status on source - The name could have been an
         // external service or singl
         // service component but neither was found.
         target = createUnresolvedWireHandle(name);
      } else {
         target = component.getSingleWireTarget();
      }
      return target;
   }

   /*
    * Resovle a WireTarget from a Component with the name componentName and a
    * service named serviceName.
    */
   private WireTarget resolveTargetForComponentService(String configurableName,
         String serviceName) {
      Component component = getComponent(configurableName);
      WireTarget target = null;
      if (component != null)
         target = component.getWireTarget(serviceName);
      return target;
   }

   public WireSource resolveWireSource(String sourceURI) {
      Assert.isNotNullOrEmtpy(sourceURI, null);
      WireSource source = null;
      int sepIndex = sourceURI.indexOf(IConstants.WIRE_PATH_SEP);
      if (sepIndex > 0) {
         // This must be a component with a reference designation.
         String componentName = sourceURI.substring(0, sepIndex);
         String referenceName = sourceURI.substring(sepIndex + 1);
         source = resolveSourceForComponentReference(componentName,
               referenceName);
      } else {
         /*
          * The source uri must be an EntryPoint or a Component with a single
          * reference.
          */
         source = getEntryPoint(sourceURI);
         if (source == null)
            source = resolveSourceComponentWithSingleReference(sourceURI);
      }
      return source;
   }

   /*
    * Resovle a WireSource from a Component with the name componentName and a
    * reference named referenceName.
    */
   private WireSource resolveSourceForComponentReference(
         String configurableName, String referenceName) {
      Component component = getComponent(configurableName);
      WireSource source = null;
      if (component != null)
         source = component.getWireSource(referenceName);
      return source;
   }

   /*
    * Resolve a WireSource for a Component with only a single reference
    * available. If there are multiple references on the Component or the
    * component fails to resolve then we have an error condition.
    */
   private WireSource resolveSourceComponentWithSingleReference(String name) {
      WireSource source = null;
      Component component = getComponent(name);
      if (component == null) {
         // TODO set error status on source - The name could have been an entry
         // point or single
         // reference component but neither was found.
         source = createUnresolvedWireHandle(name);
      } else {
         source = component.getSingleWireSource();
      }
      return source;
   }

   private UnresolvedWireHandle createUnresolvedWireHandle(String handleName) {
      return new UnresolvedWireHandle(handleName);
   }

   public EntryPoint getEntryPoint(String name) {
      Assert.isNotNullOrEmtpy(name, null);
      EntryPoint entPoint = null;
      // TODO Implement a search via an index.
      List entPoints = getEntryPoints();
      if (!entPoints.isEmpty()) {
         int size = entPoints.size();
         for (int i = 0; i < size; i++) {
            entPoint = (EntryPoint) entPoints.get(i);
            if (name.equals(entPoint.getName()))
               break;
            entPoint = null;
         }
      }
      return entPoint;
   }

   public Collection getAllWiredSources(WireTarget wireTarget) {
      Assert.isNotNull(wireTarget);
      // TODO Improve the search mechanism to use an optimized cache.
      Collection sources = null;
      // Search EntryPoints first
      List entries = getEntryPoints();
      if (!entries.isEmpty()) {
         Iterator it = entries.iterator();
         while (it.hasNext()) {
            EntryPoint ep = (EntryPoint) it.next();
            if (ep.hasWireToTarget(wireTarget)) {
               if (sources == null)
                  sources = new HashSet();
               sources.add(ep);
            }
         }
      }
      // Search components
      List components = getComponents();
      if (!components.isEmpty()) {
         Iterator it = components.iterator();
         while (it.hasNext()) {
            Component component = (Component) it.next();
            Collection componentSources = component
                  .getWireSourcesWiredToTarget(wireTarget);
            if (!componentSources.isEmpty()) {
               if (sources == null)
                  sources = new HashSet();
               sources.addAll(componentSources);
            }
         }
      }
      return sources == null ? Collections.EMPTY_LIST : sources;
   }

   /* ***** Begin Custom API ******* */

   public List getComponents() {
      return getComponentsGroup().list(
            SCAPackage.eINSTANCE.getSCACoreRoot_Component());
   }

} // CompositeImpl
