/**
 * <copyright> </copyright>
 * 
 * $Id: EntryPointImpl.java,v 1.2 2006-04-05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.AbstractService;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WireTarget;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Entry Point</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getInterfaceGroup <em>Interface Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getBindingGroup <em>Binding Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getBindings <em>Bindings</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getReferenceTargets <em>Reference Targets</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getMultiplicity <em>Multiplicity</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.EntryPointImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class EntryPointImpl extends SCAInternalObjectImpl implements EntryPoint {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright               = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getInterfaceGroup() <em>Interface Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getInterfaceGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap          interfaceGroup          = null;

   /**
    * The cached value of the '{@link #getBindingGroup() <em>Binding Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getBindingGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap          bindingGroup            = null;

   /**
    * The cached value of the '{@link #getReferenceTargets() <em>Reference Targets</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getReferenceTargets()
    * @generated
    * @ordered
    */
   protected EList               referenceTargets        = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap          any                     = null;

   /**
    * The default value of the '{@link #getMultiplicity() <em>Multiplicity</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getMultiplicity()
    * @generated
    * @ordered
    */
   protected static final String MULTIPLICITY_EDEFAULT   = "1..1";                                                                                               //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getMultiplicity() <em>Multiplicity</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getMultiplicity()
    * @generated
    * @ordered
    */
   protected String              multiplicity            = MULTIPLICITY_EDEFAULT;

   /**
    * This is true if the Multiplicity attribute has been set. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   protected boolean             multiplicityESet        = false;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String NAME_EDEFAULT           = null;

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String              name                    = NAME_EDEFAULT;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap          anyAttribute            = null;

   private List                  wiredTargets;

   private boolean               hasResolvedWiredTargets = false;

   /*
    * <doc-ku> a slight of hand with the featuremap makes for some delectable
    * code </doc-ku>
    */
   private List                  bindings;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EntryPointImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getEntryPoint();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getInterfaceGroup() {
      if (interfaceGroup == null) {
         interfaceGroup = new BasicFeatureMap(this,
               SCAPackage.ENTRY_POINT__INTERFACE_GROUP);
      }
      return interfaceGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Interface getInterface() {
      return (Interface) getInterfaceGroup().get(
            SCAPackage.eINSTANCE.getEntryPoint_Interface(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetInterface(Interface newInterface,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getInterfaceGroup()).basicAdd(
            SCAPackage.eINSTANCE.getEntryPoint_Interface(), newInterface, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public void setInterface(Interface newInterface) {
      if (newInterface != null) {
         EStructuralFeature feature = FeatureAdapter.getFeature(newInterface);
         Assert.isNotNull(feature);
         getInterfaceGroup().set(feature, newInterface);
      } else {
         setInterfaceGen(null);
      }
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setInterfaceGen(Interface newInterface) {
      ((FeatureMap.Internal) getInterfaceGroup()).set(SCAPackage.eINSTANCE
            .getEntryPoint_Interface(), newInterface);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getBindingGroup() {
      if (bindingGroup == null) {
         bindingGroup = new BasicFeatureMap(this,
               SCAPackage.ENTRY_POINT__BINDING_GROUP);
      }
      return bindingGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public List getBindings() {
      if (bindings == null)
         bindings = new FeatureAwareList(SCAPackage.eINSTANCE
               .getEntryPoint_Bindings(),
               (FeatureMap.Internal) getBindingGroup());
      return bindings;

   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getBindingsGen() {
      return ((FeatureMap) getBindingGroup()).list(SCAPackage.eINSTANCE
            .getEntryPoint_Bindings());
   }

   /*
    * Use the WireTargets if they are resolved. Clients should be using
    * getWireTargets(). This will only be used by the serializer and parser.
    */
   public List getReferenceTargets() {
      if (hasResolvedWiredTargets)
         return getReferenceTargetURIsFromWireTargets();
      return getReferenceTargetsGen();
   }

   private List getReferenceTargetURIsFromWireTargets() {
      if (wiredTargets.isEmpty())
         return Collections.EMPTY_LIST;
      List uris = new ArrayList(wiredTargets.size());
      for (int i = 0; i < wiredTargets.size(); i++)
         uris.add(((WireTarget) wiredTargets.get(i)).getName());
      return uris;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getReferenceTargetsGen() {
      if (referenceTargets == null) {
         referenceTargets = new EDataTypeEList(String.class, this,
               SCAPackage.ENTRY_POINT__REFERENCE_TARGETS);
      }
      return referenceTargets;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.ENTRY_POINT__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getMultiplicity() {
      return multiplicity;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setMultiplicity(String newMultiplicity) {
      String oldMultiplicity = multiplicity;
      multiplicity = newMultiplicity;
      boolean oldMultiplicityESet = multiplicityESet;
      multiplicityESet = true;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.ENTRY_POINT__MULTIPLICITY, oldMultiplicity,
               multiplicity, !oldMultiplicityESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void unsetMultiplicity() {
      String oldMultiplicity = multiplicity;
      boolean oldMultiplicityESet = multiplicityESet;
      multiplicity = MULTIPLICITY_EDEFAULT;
      multiplicityESet = false;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.UNSET,
               SCAPackage.ENTRY_POINT__MULTIPLICITY, oldMultiplicity,
               MULTIPLICITY_EDEFAULT, oldMultiplicityESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isSetMultiplicity() {
      return multiplicityESet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getName() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setName(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.ENTRY_POINT__NAME, oldName, name));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.ENTRY_POINT__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.ENTRY_POINT__INTERFACE_GROUP:
               return ((InternalEList) getInterfaceGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.ENTRY_POINT__INTERFACE:
               return basicSetInterface(null, msgs);
            case SCAPackage.ENTRY_POINT__BINDING_GROUP:
               return ((InternalEList) getBindingGroup()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.ENTRY_POINT__BINDINGS:
               return ((InternalEList) getBindings()).basicRemove(otherEnd,
                     msgs);
            case SCAPackage.ENTRY_POINT__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.ENTRY_POINT__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.ENTRY_POINT__INTERFACE_GROUP:
            return getInterfaceGroup();
         case SCAPackage.ENTRY_POINT__INTERFACE:
            return getInterface();
         case SCAPackage.ENTRY_POINT__BINDING_GROUP:
            return getBindingGroup();
         case SCAPackage.ENTRY_POINT__BINDINGS:
            return getBindings();
         case SCAPackage.ENTRY_POINT__REFERENCE_TARGETS:
            return getReferenceTargets();
         case SCAPackage.ENTRY_POINT__ANY:
            return getAny();
         case SCAPackage.ENTRY_POINT__MULTIPLICITY:
            return getMultiplicity();
         case SCAPackage.ENTRY_POINT__NAME:
            return getName();
         case SCAPackage.ENTRY_POINT__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.ENTRY_POINT__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            getInterfaceGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.ENTRY_POINT__INTERFACE:
            setInterface((Interface) newValue);
            return;
         case SCAPackage.ENTRY_POINT__BINDING_GROUP:
            getBindingGroup().clear();
            getBindingGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.ENTRY_POINT__BINDINGS:
            getBindings().clear();
            getBindings().addAll((Collection) newValue);
            return;
         case SCAPackage.ENTRY_POINT__REFERENCE_TARGETS:
            getReferenceTargets().clear();
            getReferenceTargets().addAll((Collection) newValue);
            return;
         case SCAPackage.ENTRY_POINT__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.ENTRY_POINT__MULTIPLICITY:
            setMultiplicity((String) newValue);
            return;
         case SCAPackage.ENTRY_POINT__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.ENTRY_POINT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.ENTRY_POINT__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            return;
         case SCAPackage.ENTRY_POINT__INTERFACE:
            setInterface((Interface) null);
            return;
         case SCAPackage.ENTRY_POINT__BINDING_GROUP:
            getBindingGroup().clear();
            return;
         case SCAPackage.ENTRY_POINT__BINDINGS:
            getBindings().clear();
            return;
         case SCAPackage.ENTRY_POINT__REFERENCE_TARGETS:
            getReferenceTargets().clear();
            return;
         case SCAPackage.ENTRY_POINT__ANY:
            getAny().clear();
            return;
         case SCAPackage.ENTRY_POINT__MULTIPLICITY:
            unsetMultiplicity();
            return;
         case SCAPackage.ENTRY_POINT__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.ENTRY_POINT__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.ENTRY_POINT__INTERFACE_GROUP:
            return interfaceGroup != null && !interfaceGroup.isEmpty();
         case SCAPackage.ENTRY_POINT__INTERFACE:
            return getInterface() != null;
         case SCAPackage.ENTRY_POINT__BINDING_GROUP:
            return bindingGroup != null && !bindingGroup.isEmpty();
         case SCAPackage.ENTRY_POINT__BINDINGS:
            return !getBindings().isEmpty();
         case SCAPackage.ENTRY_POINT__REFERENCE_TARGETS:
            return referenceTargets != null && !referenceTargets.isEmpty();
         case SCAPackage.ENTRY_POINT__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.ENTRY_POINT__MULTIPLICITY:
            return isSetMultiplicity();
         case SCAPackage.ENTRY_POINT__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.ENTRY_POINT__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (interfaceGroup: "); //$NON-NLS-1$
      result.append(interfaceGroup);
      result.append(", bindingGroup: "); //$NON-NLS-1$
      result.append(bindingGroup);
      result.append(", referenceTargets: "); //$NON-NLS-1$
      result.append(referenceTargets);
      result.append(", any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", multiplicity: "); //$NON-NLS-1$
      if (multiplicityESet)
         result.append(multiplicity);
      else
         result.append("<unset>"); //$NON-NLS-1$
      result.append(", name: "); //$NON-NLS-1$
      result.append(name);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.eclipse.stp.core.sca.impl.SOAInternalObject#getFlags()
    */
   public int getFlags() {
      return IConstants.F_POSSIBLE_WIRE_SOURCE | IConstants.F_BOUNDARY_ELEMENT;
   }

   public boolean matches(WireTarget wireTarget) {
      Assert.isNotNull(wireTarget);
      if (getInterface() != null)
         return getInterface().equals(wireTarget.getInterface());
      return false;
   }

   public void createWireToTarget(WireTarget wireTarget) {
      getWiredTargetsGen().add(wireTarget);
      // Removed the conditional. This logic was preventing multiple wiretargets
      // from creating notification.
      // /*
      // * If this is the first target then we must add it to the
      // * referenceTargets list so it will serialize properly.
      // */
      // if (referenceTargets == null || referenceTargets.isEmpty())
      getReferenceTargetsGen().add(wireTarget.getName());
   }

   public List getWiredTargets() {
      if (!hasResolvedWiredTargets) {
         hasResolvedWiredTargets = true;
         if (wiredTargets == null)
            wiredTargets = new ArrayList(getReferenceTargetsGen().size());
         resolveWiredTargets();
      }
      return wiredTargets;
   }

   private List getWiredTargetsGen() {
      if (wiredTargets == null)
         wiredTargets = new ArrayList(getReferenceTargetsGen().size() + 1);
      return wiredTargets;
   }

   private Composite getComposite() {
      return (Composite) eContainer();
   }

   /*
    * Resolve WireTargets for each element in the referencedTargets list.
    */
   private void resolveWiredTargets() {
      if (referenceTargets != null && !referenceTargets.isEmpty()) {
         WireTarget target;
         Composite composite = getComposite();
         if (composite != null) {
            for (int i = 0; i < referenceTargets.size(); i++) {
               target = composite.resolveWireTarget((String) referenceTargets
                     .get(i));
               if (target != null && !wiredTargets.contains(target))
                  wiredTargets.add(target);
            }
         }
      }
   }

   public boolean isResolved() {
      return true;
   }

   public boolean deleteWireToTarget(WireTarget wireTarget) {
      boolean result = false;
      if (hasResolvedWiredTargets)
         result = getWiredTargetsGen().remove(wireTarget);
      result = getReferenceTargetsGen().remove(wireTarget.getName()) || result;
      return result;
   }

   public boolean isComponentOwned() {
      return false;
   }

   public boolean hasWireToTarget(WireTarget wireTarget) {
      if (wireTarget != null) {
         if (hasResolvedWiredTargets) {
            if (wiredTargets.contains(wireTarget))
               return true;
            // Test names
            for (int i = 0; i < wiredTargets.size(); i++) {
               WireTarget target = (WireTarget) wiredTargets.get(i);
               if (wireTarget.getName().equals(target.getName()))
                  return true;
            }
         } else if (!getReferenceTargetsGen().isEmpty()) {
            List references = getReferenceTargetsGen();
            for (int i = 0; i < references.size(); i++) {
               if (wireTarget.getName().equals(references.get(i)))
                  return true;
            }
         }
      }
      return false;
   }

   public boolean matches(AbstractService service) {
      Assert.isNotNull(service);
      if (getInterface() != null)
         return getInterface().equals(service.getInterface());
      return false;
   }

} // EntryPointImpl
