/**
 * <copyright> </copyright>
 * 
 * $Id: ReferenceImpl.java,v 1.2 2006-04-05 14:26:12 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.AbstractService;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceImpl#getInterfaceGroup <em>Interface Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceImpl#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceImpl#getMultiplicity <em>Multiplicity</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceImpl#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ReferenceImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ReferenceImpl extends SCAInternalObjectImpl implements Reference {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright             = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getInterfaceGroup() <em>Interface Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getInterfaceGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap          interfaceGroup        = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap          any                   = null;

   /**
    * The default value of the '{@link #getMultiplicity() <em>Multiplicity</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getMultiplicity()
    * @generated
    * @ordered
    */
   protected static final String MULTIPLICITY_EDEFAULT = "1..1";                                                                                               //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getMultiplicity() <em>Multiplicity</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getMultiplicity()
    * @generated
    * @ordered
    */
   protected String              multiplicity          = MULTIPLICITY_EDEFAULT;

   /**
    * This is true if the Multiplicity attribute has been set. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   protected boolean             multiplicityESet      = false;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String NAME_EDEFAULT         = null;

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String              name                  = NAME_EDEFAULT;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap          anyAttribute          = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ReferenceImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getReference();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getInterfaceGroup() {
      if (interfaceGroup == null) {
         interfaceGroup = new BasicFeatureMap(this,
               SCAPackage.REFERENCE__INTERFACE_GROUP);
      }
      return interfaceGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public Interface getInterface() {
      if (getInterfaceGroup().isEmpty())
         return null;
      return (Interface) getInterfaceGroup().getValue(0);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Interface getInterfaceGen() {
      return (Interface) getInterfaceGroup().get(
            SCAPackage.eINSTANCE.getReference_Interface(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetInterface(Interface newInterface,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getInterfaceGroup()).basicAdd(
            SCAPackage.eINSTANCE.getReference_Interface(), newInterface, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public void setInterface(Interface newInterface) {
      EStructuralFeature feature = FeatureAdapter.getFeature(newInterface);
      Assert.isNotNull(feature);
      getInterfaceGroup().set(feature, newInterface);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setInterfaceGen(Interface newInterface) {
      ((FeatureMap.Internal) getInterfaceGroup()).set(SCAPackage.eINSTANCE
            .getReference_Interface(), newInterface);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.REFERENCE__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getMultiplicity() {
      return multiplicity;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setMultiplicity(String newMultiplicity) {
      String oldMultiplicity = multiplicity;
      multiplicity = newMultiplicity;
      boolean oldMultiplicityESet = multiplicityESet;
      multiplicityESet = true;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.REFERENCE__MULTIPLICITY, oldMultiplicity,
               multiplicity, !oldMultiplicityESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void unsetMultiplicity() {
      String oldMultiplicity = multiplicity;
      boolean oldMultiplicityESet = multiplicityESet;
      multiplicity = MULTIPLICITY_EDEFAULT;
      multiplicityESet = false;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.UNSET,
               SCAPackage.REFERENCE__MULTIPLICITY, oldMultiplicity,
               MULTIPLICITY_EDEFAULT, oldMultiplicityESet));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean isSetMultiplicity() {
      return multiplicityESet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getName() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setName(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.REFERENCE__NAME, oldName, name));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.REFERENCE__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.REFERENCE__INTERFACE_GROUP:
               return ((InternalEList) getInterfaceGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.REFERENCE__INTERFACE:
               return basicSetInterface(null, msgs);
            case SCAPackage.REFERENCE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.REFERENCE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE__INTERFACE_GROUP:
            return getInterfaceGroup();
         case SCAPackage.REFERENCE__INTERFACE:
            return getInterface();
         case SCAPackage.REFERENCE__ANY:
            return getAny();
         case SCAPackage.REFERENCE__MULTIPLICITY:
            return getMultiplicity();
         case SCAPackage.REFERENCE__NAME:
            return getName();
         case SCAPackage.REFERENCE__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            getInterfaceGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.REFERENCE__INTERFACE:
            setInterface((Interface) newValue);
            return;
         case SCAPackage.REFERENCE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.REFERENCE__MULTIPLICITY:
            setMultiplicity((String) newValue);
            return;
         case SCAPackage.REFERENCE__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.REFERENCE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            return;
         case SCAPackage.REFERENCE__INTERFACE:
            setInterface((Interface) null);
            return;
         case SCAPackage.REFERENCE__ANY:
            getAny().clear();
            return;
         case SCAPackage.REFERENCE__MULTIPLICITY:
            unsetMultiplicity();
            return;
         case SCAPackage.REFERENCE__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.REFERENCE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.REFERENCE__INTERFACE_GROUP:
            return interfaceGroup != null && !interfaceGroup.isEmpty();
         case SCAPackage.REFERENCE__INTERFACE:
            return getInterface() != null;
         case SCAPackage.REFERENCE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.REFERENCE__MULTIPLICITY:
            return isSetMultiplicity();
         case SCAPackage.REFERENCE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.REFERENCE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (interfaceGroup: "); //$NON-NLS-1$
      result.append(interfaceGroup);
      result.append(", any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", multiplicity: "); //$NON-NLS-1$
      if (multiplicityESet)
         result.append(multiplicity);
      else
         result.append("<unset>"); //$NON-NLS-1$
      result.append(", name: "); //$NON-NLS-1$
      result.append(name);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.eclipse.stp.core.sca.impl.SOAInternalObject#getFlags()
    */
   public int getFlags() {
      return IConstants.F_POSSIBLE_WIRE_SOURCE;
   }

   public boolean matches(AbstractService service) {
      Assert.isNotNull(service);
      if (getInterface() != null)
         return getInterface().equals(service.getInterface());
      return false;
   }

} // ReferenceImpl
