/**
 * <copyright> </copyright>
 * 
 * $Id: SCAFactoryImpl.java,v 1.1 2006-03-31 21:58:48 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Binding;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.ModuleComponent;
import org.eclipse.stp.core.sca.ModuleFragment;
import org.eclipse.stp.core.sca.ModuleReference;
import org.eclipse.stp.core.sca.ModuleService;
import org.eclipse.stp.core.sca.ModuleWire;
import org.eclipse.stp.core.sca.OverrideOptions;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.ReferenceValue;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCABinding;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.SLSBBinding;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.Subsystem;
import org.eclipse.stp.core.sca.SystemWire;
import org.eclipse.stp.core.sca.UnknownImplementation;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.stp.core.sca.WebServiceBinding;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class SCAFactoryImpl extends EFactoryImpl implements SCAFactory {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Creates an instance of the factory. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public SCAFactoryImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EObject create(EClass eClass) {
      switch (eClass.getClassifierID()) {
         case SCAPackage.ABSTRACT_IMPLEMENTATION:
            return (EObject) createAbstractImplementation();
         case SCAPackage.BINDING:
            return (EObject) createBinding();
         case SCAPackage.COMPONENT_TYPE:
            return (EObject) createComponentType();
         case SCAPackage.COMPOSITE:
            return (EObject) createComposite();
         case SCAPackage.ENTRY_POINT:
            return (EObject) createEntryPoint();
         case SCAPackage.EXTERNAL_SERVICE:
            return (EObject) createExternalService();
         case SCAPackage.IMPLEMENTATION_COMPONENT:
            return (EObject) createImplementationComponent();
         case SCAPackage.INTERFACE:
            return (EObject) createInterface();
         case SCAPackage.JAVA_IMPLEMENTATION:
            return (EObject) createJavaImplementation();
         case SCAPackage.JAVA_INTERFACE:
            return (EObject) createJavaInterface();
         case SCAPackage.MODULE:
            return (EObject) createModule();
         case SCAPackage.MODULE_COMPONENT:
            return (EObject) createModuleComponent();
         case SCAPackage.MODULE_FRAGMENT:
            return (EObject) createModuleFragment();
         case SCAPackage.MODULE_REFERENCE:
            return (EObject) createModuleReference();
         case SCAPackage.MODULE_SERVICE:
            return (EObject) createModuleService();
         case SCAPackage.MODULE_WIRE:
            return (EObject) createModuleWire();
         case SCAPackage.PROPERTY:
            return (EObject) createProperty();
         case SCAPackage.PROPERTY_VALUE:
            return (EObject) createPropertyValue();
         case SCAPackage.PROPERTY_VALUES_SET:
            return (EObject) createPropertyValuesSet();
         case SCAPackage.REFERENCE:
            return (EObject) createReference();
         case SCAPackage.REFERENCE_VALUE:
            return (EObject) createReferenceValue();
         case SCAPackage.REFERENCE_VALUES_SET:
            return (EObject) createReferenceValuesSet();
         case SCAPackage.SCA_BINDING:
            return (EObject) createSCABinding();
         case SCAPackage.SCA_CORE_ROOT:
            return (EObject) createSCACoreRoot();
         case SCAPackage.SERVICE:
            return (EObject) createService();
         case SCAPackage.SLSB_BINDING:
            return (EObject) createSLSBBinding();
         case SCAPackage.SUBSYSTEM:
            return (EObject) createSubsystem();
         case SCAPackage.SYSTEM_WIRE:
            return (EObject) createSystemWire();
         case SCAPackage.UNKNOWN_IMPLEMENTATION:
            return (EObject) createUnknownImplementation();
         case SCAPackage.WEB_SERVICE_BINDING:
            return (EObject) createWebServiceBinding();
         case SCAPackage.WSDL_PORT_TYPE:
            return (EObject) createWSDLPortType();
         default:
            throw new IllegalArgumentException(
                  "The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
      }
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object createFromString(EDataType eDataType, String initialValue) {
      switch (eDataType.getClassifierID()) {
         case SCAPackage.OVERRIDE_OPTIONS: {
            OverrideOptions result = OverrideOptions.get(initialValue);
            if (result == null)
               throw new IllegalArgumentException(
                     "The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
            return result;
         }
         case SCAPackage.MULTIPLICITY:
            return createMultiplicityFromString(eDataType, initialValue);
         case SCAPackage.OVERRIDE_OPTIONS_OBJECT:
            return createOverrideOptionsObjectFromString(eDataType,
                  initialValue);
         default:
            throw new IllegalArgumentException(
                  "The datatype '" + eDataType.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
      }
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String convertToString(EDataType eDataType, Object instanceValue) {
      switch (eDataType.getClassifierID()) {
         case SCAPackage.OVERRIDE_OPTIONS:
            return instanceValue == null ? null : instanceValue.toString();
         case SCAPackage.MULTIPLICITY:
            return convertMultiplicityToString(eDataType, instanceValue);
         case SCAPackage.OVERRIDE_OPTIONS_OBJECT:
            return convertOverrideOptionsObjectToString(eDataType,
                  instanceValue);
         default:
            throw new IllegalArgumentException(
                  "The datatype '" + eDataType.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
      }
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public AbstractImplementation createAbstractImplementation() {
      AbstractImplementationImpl abstractImplementation = new AbstractImplementationImpl();
      return abstractImplementation;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Binding createBinding() {
      BindingImpl binding = new BindingImpl();
      return binding;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ComponentType createComponentType() {
      ComponentTypeImpl componentType = new ComponentTypeImpl();
      return componentType;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Composite createComposite() {
      CompositeImpl composite = new CompositeImpl();
      return composite;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public EntryPoint createEntryPoint() {
      EntryPointImpl entryPoint = new EntryPointImpl();
      return entryPoint;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ExternalService createExternalService() {
      ExternalServiceImpl externalService = new ExternalServiceImpl();
      return externalService;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ImplementationComponent createImplementationComponent() {
      ImplementationComponentImpl implementationComponent = new ImplementationComponentImpl();
      return implementationComponent;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public Interface createInterface() {
      Interface interface_ = createInterfaceGen();
      FeatureAdapter.setFeature(interface_, SCAPackage.eINSTANCE
            .getSCACoreRoot_Interface());
      return interface_;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Interface createInterfaceGen() {
      InterfaceImpl interface_ = new InterfaceImpl();
      return interface_;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public JavaImplementation createJavaImplementation() {
      JavaImplementation javaImplementation = createJavaImplementationGen();
      FeatureAdapter.setFeature(javaImplementation, SCAPackage.eINSTANCE
            .getSCACoreRoot_ImplementationJava());
      return javaImplementation;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public JavaImplementation createJavaImplementationGen() {
      JavaImplementationImpl javaImplementation = new JavaImplementationImpl();
      return javaImplementation;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public JavaInterface createJavaInterface() {
      JavaInterface javaInterface = createJavaInterfaceGen();
      FeatureAdapter.setFeature(javaInterface, SCAPackage.eINSTANCE
            .getSCACoreRoot_InterfaceJava());
      return javaInterface;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public JavaInterface createJavaInterfaceGen() {
      JavaInterfaceImpl javaInterface = new JavaInterfaceImpl();
      return javaInterface;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Module createModule() {
      ModuleImpl module = new ModuleImpl();
      return module;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleComponent createModuleComponent() {
      ModuleComponentImpl moduleComponent = new ModuleComponentImpl();
      return moduleComponent;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleFragment createModuleFragment() {
      ModuleFragmentImpl moduleFragment = new ModuleFragmentImpl();
      return moduleFragment;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleReference createModuleReference() {
      ModuleReferenceImpl moduleReference = new ModuleReferenceImpl();
      return moduleReference;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleService createModuleService() {
      ModuleServiceImpl moduleService = new ModuleServiceImpl();
      return moduleService;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ModuleWire createModuleWire() {
      ModuleWireImpl moduleWire = new ModuleWireImpl();
      return moduleWire;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Property createProperty() {
      PropertyImpl property = new PropertyImpl();
      return property;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public PropertyValue createPropertyValue() {
      PropertyValueImpl propertyValue = new PropertyValueImpl();
      return propertyValue;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public PropertyValuesSet createPropertyValuesSet() {
      PropertyValuesSetImpl propertyValuesSet = new PropertyValuesSetImpl();
      return propertyValuesSet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Reference createReference() {
      ReferenceImpl reference = new ReferenceImpl();
      return reference;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ReferenceValue createReferenceValue() {
      ReferenceValueImpl referenceValue = new ReferenceValueImpl();
      return referenceValue;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ReferenceValuesSet createReferenceValuesSet() {
      ReferenceValuesSetImpl referenceValuesSet = new ReferenceValuesSetImpl();
      return referenceValuesSet;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public SCABinding createSCABinding() {
      SCABinding scaBinding = createSCABindingGen();
      FeatureAdapter.setFeature(scaBinding, getSCAPackage()
            .getSCACoreRoot_BindingSca());
      return scaBinding;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SCABinding createSCABindingGen() {
      SCABindingImpl scaBinding = new SCABindingImpl();
      return scaBinding;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SCACoreRoot createSCACoreRoot() {
      SCACoreRootImpl scaCoreRoot = new SCACoreRootImpl();
      return scaCoreRoot;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Service createService() {
      ServiceImpl service = new ServiceImpl();
      return service;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public SLSBBinding createSLSBBinding() {
      SLSBBinding slsbBinding = createSLSBBindingGen();
      FeatureAdapter.setFeature(slsbBinding, getSCAPackage()
            .getSCACoreRoot_BindingEjb());
      return slsbBinding;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public SLSBBinding createSLSBBindingGen() {
      SLSBBindingImpl slsbBinding = new SLSBBindingImpl();
      return slsbBinding;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Subsystem createSubsystem() {
      SubsystemImpl subsystem = new SubsystemImpl();
      return subsystem;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SystemWire createSystemWire() {
      SystemWireImpl systemWire = new SystemWireImpl();
      return systemWire;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public UnknownImplementation createUnknownImplementation() {
      UnknownImplementationImpl unknownImplementation = new UnknownImplementationImpl();
      return unknownImplementation;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public WebServiceBinding createWebServiceBinding() {
      WebServiceBinding webServiceBinding = createWebServiceBindingGen();
      FeatureAdapter.setFeature(webServiceBinding, SCAPackage.eINSTANCE
            .getSCACoreRoot_BindingWs());
      return webServiceBinding;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public WebServiceBinding createWebServiceBindingGen() {
      WebServiceBindingImpl webServiceBinding = new WebServiceBindingImpl();
      return webServiceBinding;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public WSDLPortType createWSDLPortType() {
      WSDLPortType wsdlPortType = createWSDLPortTypeGen();
      FeatureAdapter.setFeature(wsdlPortType, getSCAPackage()
            .getSCACoreRoot_InterfaceWsdl());
      return wsdlPortType;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public WSDLPortType createWSDLPortTypeGen() {
      WSDLPortTypeImpl wsdlPortType = new WSDLPortTypeImpl();
      return wsdlPortType;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String createMultiplicityFromString(EDataType eDataType,
         String initialValue) {
      return (String) XMLTypeFactory.eINSTANCE.createFromString(
            XMLTypePackage.eINSTANCE.getString(), initialValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String convertMultiplicityToString(EDataType eDataType,
         Object instanceValue) {
      return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.eINSTANCE
            .getString(), instanceValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public OverrideOptions createOverrideOptionsObjectFromString(
         EDataType eDataType, String initialValue) {
      return (OverrideOptions) SCAFactory.eINSTANCE.createFromString(
            SCAPackage.eINSTANCE.getOverrideOptions(), initialValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String convertOverrideOptionsObjectToString(EDataType eDataType,
         Object instanceValue) {
      return SCAFactory.eINSTANCE.convertToString(SCAPackage.eINSTANCE
            .getOverrideOptions(), instanceValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SCAPackage getSCAPackage() {
      return (SCAPackage) getEPackage();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @deprecated
    * @generated
    */
   public static SCAPackage getPackage() {
      return SCAPackage.eINSTANCE;
   }

   public Component createComponent() {
      return createImplementationComponent();
   }

} // SCAFactoryImpl
