/**
 * <copyright> </copyright>
 * 
 * $Id: ServiceImpl.java,v 1.2 2006-04-05 14:26:13 melder Exp $
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.AbstractReference;
import org.eclipse.stp.core.sca.IConstants;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;

/**
 * <!-- begin-user-doc --> An implementation of the model object '<em><b>Service</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.impl.ServiceImpl#getInterfaceGroup <em>Interface Group</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ServiceImpl#getInterface <em>Interface</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ServiceImpl#getAny <em>Any</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ServiceImpl#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.impl.ServiceImpl#getAnyAttribute <em>Any Attribute</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ServiceImpl extends SCAInternalObjectImpl implements Service {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String    copyright      = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * The cached value of the '{@link #getInterfaceGroup() <em>Interface Group</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getInterfaceGroup()
    * @generated
    * @ordered
    */
   protected FeatureMap          interfaceGroup = null;

   /**
    * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAny()
    * @generated
    * @ordered
    */
   protected FeatureMap          any            = null;

   /**
    * The default value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected static final String NAME_EDEFAULT  = null;

   /**
    * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getName()
    * @generated
    * @ordered
    */
   protected String              name           = NAME_EDEFAULT;

   /**
    * The cached value of the '{@link #getAnyAttribute() <em>Any Attribute</em>}'
    * attribute list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see #getAnyAttribute()
    * @generated
    * @ordered
    */
   protected FeatureMap          anyAttribute   = null;

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected ServiceImpl() {
      super();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected EClass eStaticClass() {
      return SCAPackage.eINSTANCE.getService();
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getInterfaceGroup() {
      if (interfaceGroup == null) {
         interfaceGroup = new BasicFeatureMap(this,
               SCAPackage.SERVICE__INTERFACE_GROUP);
      }
      return interfaceGroup;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Interface getInterface() {
      return (Interface) getInterfaceGroup().get(
            SCAPackage.eINSTANCE.getService_Interface(), true);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain basicSetInterface(Interface newInterface,
         NotificationChain msgs) {
      return ((FeatureMap.Internal) getInterfaceGroup()).basicAdd(
            SCAPackage.eINSTANCE.getService_Interface(), newInterface, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    */
   public void setInterface(Interface newInterface) {
      EStructuralFeature feature = FeatureAdapter.getFeature(newInterface);
      Assert.isNotNull(feature);
      getInterfaceGroup().set(feature, newInterface);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setInterfaceGen(Interface newInterface) {
      ((FeatureMap.Internal) getInterfaceGroup()).set(SCAPackage.eINSTANCE
            .getService_Interface(), newInterface);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAny() {
      if (any == null) {
         any = new BasicFeatureMap(this, SCAPackage.SERVICE__ANY);
      }
      return any;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getName() {
      return name;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void setName(String newName) {
      String oldName = name;
      name = newName;
      if (eNotificationRequired())
         eNotify(new ENotificationImpl(this, Notification.SET,
               SCAPackage.SERVICE__NAME, oldName, name));
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public FeatureMap getAnyAttribute() {
      if (anyAttribute == null) {
         anyAttribute = new BasicFeatureMap(this,
               SCAPackage.SERVICE__ANY_ATTRIBUTE);
      }
      return anyAttribute;
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public NotificationChain eInverseRemove(InternalEObject otherEnd,
         int featureID, Class baseClass, NotificationChain msgs) {
      if (featureID >= 0) {
         switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
            case SCAPackage.SERVICE__INTERFACE_GROUP:
               return ((InternalEList) getInterfaceGroup()).basicRemove(
                     otherEnd, msgs);
            case SCAPackage.SERVICE__INTERFACE:
               return basicSetInterface(null, msgs);
            case SCAPackage.SERVICE__ANY:
               return ((InternalEList) getAny()).basicRemove(otherEnd, msgs);
            case SCAPackage.SERVICE__ANY_ATTRIBUTE:
               return ((InternalEList) getAnyAttribute()).basicRemove(otherEnd,
                     msgs);
            default:
               return eDynamicInverseRemove(otherEnd, featureID, baseClass,
                     msgs);
         }
      }
      return eBasicSetContainer(null, featureID, msgs);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Object eGet(EStructuralFeature eFeature, boolean resolve) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SERVICE__INTERFACE_GROUP:
            return getInterfaceGroup();
         case SCAPackage.SERVICE__INTERFACE:
            return getInterface();
         case SCAPackage.SERVICE__ANY:
            return getAny();
         case SCAPackage.SERVICE__NAME:
            return getName();
         case SCAPackage.SERVICE__ANY_ATTRIBUTE:
            return getAnyAttribute();
      }
      return eDynamicGet(eFeature, resolve);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eSet(EStructuralFeature eFeature, Object newValue) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SERVICE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            getInterfaceGroup().addAll((Collection) newValue);
            return;
         case SCAPackage.SERVICE__INTERFACE:
            setInterface((Interface) newValue);
            return;
         case SCAPackage.SERVICE__ANY:
            getAny().clear();
            getAny().addAll((Collection) newValue);
            return;
         case SCAPackage.SERVICE__NAME:
            setName((String) newValue);
            return;
         case SCAPackage.SERVICE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            getAnyAttribute().addAll((Collection) newValue);
            return;
      }
      eDynamicSet(eFeature, newValue);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public void eUnset(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SERVICE__INTERFACE_GROUP:
            getInterfaceGroup().clear();
            return;
         case SCAPackage.SERVICE__INTERFACE:
            setInterface((Interface) null);
            return;
         case SCAPackage.SERVICE__ANY:
            getAny().clear();
            return;
         case SCAPackage.SERVICE__NAME:
            setName(NAME_EDEFAULT);
            return;
         case SCAPackage.SERVICE__ANY_ATTRIBUTE:
            getAnyAttribute().clear();
            return;
      }
      eDynamicUnset(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public boolean eIsSet(EStructuralFeature eFeature) {
      switch (eDerivedStructuralFeatureID(eFeature)) {
         case SCAPackage.SERVICE__INTERFACE_GROUP:
            return interfaceGroup != null && !interfaceGroup.isEmpty();
         case SCAPackage.SERVICE__INTERFACE:
            return getInterface() != null;
         case SCAPackage.SERVICE__ANY:
            return any != null && !any.isEmpty();
         case SCAPackage.SERVICE__NAME:
            return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT
                  .equals(name);
         case SCAPackage.SERVICE__ANY_ATTRIBUTE:
            return anyAttribute != null && !anyAttribute.isEmpty();
      }
      return eDynamicIsSet(eFeature);
   }

   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String toString() {
      if (eIsProxy())
         return super.toString();

      StringBuffer result = new StringBuffer(super.toString());
      result.append(" (interfaceGroup: "); //$NON-NLS-1$
      result.append(interfaceGroup);
      result.append(", any: "); //$NON-NLS-1$
      result.append(any);
      result.append(", name: "); //$NON-NLS-1$
      result.append(name);
      result.append(", anyAttribute: "); //$NON-NLS-1$
      result.append(anyAttribute);
      result.append(')');
      return result.toString();
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.eclipse.stp.core.sca.impl.SOAInternalObject#getFlags()
    */
   public int getFlags() {
      return IConstants.F_POSSIBLE_WIRE_TARGET;
   }

   public boolean matches(AbstractReference reference) {
      Assert.isNotNull(reference);
      if (getInterface() != null)
         return getInterface().equals(reference.getInterface());
      return false;
   }
} // ServiceImpl
