/**
 * <copyright> </copyright>
 * 
 * $Id: SCACoreRootItemProvider.java,v 1.2 2006-04-05 14:26:13 melder Exp $
 */
package org.eclipse.stp.core.sca.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * This is the item provider adapter for a
 * {@link org.eclipse.stp.core.sca.SCACoreRoot} object. <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * 
 * @generated
 */
public class SCACoreRootItemProvider extends ItemProviderAdapter implements
      IEditingDomainItemProvider, IStructuredItemContentProvider,
      ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * This constructs an instance from a factory and a notifier. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public SCACoreRootItemProvider(AdapterFactory adapterFactory) {
      super(adapterFactory);
   }

   /**
    * This returns the property descriptors for the adapted class. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public List getPropertyDescriptors(Object object) {
      if (itemPropertyDescriptors == null) {
         super.getPropertyDescriptors(object);

         addSourceUriPropertyDescriptor(object);
         addTargetUriPropertyDescriptor(object);
      }
      return itemPropertyDescriptors;
   }

   /**
    * This adds a property descriptor for the Source Uri feature. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addSourceUriPropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_SCACoreRoot_sourceUri_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_SCACoreRoot_sourceUri_feature", "_UI_SCACoreRoot_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getSCACoreRoot_SourceUri(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This adds a property descriptor for the Target Uri feature. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void addTargetUriPropertyDescriptor(Object object) {
      itemPropertyDescriptors
            .add(createItemPropertyDescriptor(
                  ((ComposeableAdapterFactory) adapterFactory)
                        .getRootAdapterFactory(),
                  getResourceLocator(),
                  getString("_UI_SCACoreRoot_targetUri_feature"), //$NON-NLS-1$
                  getString(
                        "_UI_PropertyDescriptor_description", "_UI_SCACoreRoot_targetUri_feature", "_UI_SCACoreRoot_type"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                  SCAPackage.eINSTANCE.getSCACoreRoot_TargetUri(), true,
                  ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
   }

   /**
    * This specifies how to implement {@link #getChildren} and is used to deduce
    * an appropriate feature for an
    * {@link org.eclipse.emf.edit.command.AddCommand},
    * {@link org.eclipse.emf.edit.command.RemoveCommand} or
    * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public Collection getChildrenFeatures(Object object) {
      if (childrenFeatures == null) {
         super.getChildrenFeatures(object);
         childrenFeatures.add(SCAPackage.eINSTANCE.getSCACoreRoot_Mixed());
      }
      return childrenFeatures;
   }

   /**
    * This returns SCACoreRoot.gif. <!-- begin-user-doc --> <!-- end-user-doc
    * -->
    * 
    * @generated
    */
   public Object getImage(Object object) {
      return getResourceLocator().getImage("full/obj16/SCACoreRoot"); //$NON-NLS-1$
   }

   /**
    * This returns the label text for the adapted class. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getText(Object object) {
      String label = ((SCACoreRoot) object).getSourceUri();
      return label == null || label.length() == 0 ? getString("_UI_SCACoreRoot_type") : //$NON-NLS-1$
            getString("_UI_SCACoreRoot_type") + " " + label; //$NON-NLS-1$ //$NON-NLS-2$
   }

   /**
    * This handles model notifications by calling {@link #updateChildren} to
    * update any cached children and by creating a viewer notification, which it
    * passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public void notifyChanged(Notification notification) {
      updateChildren(notification);

      switch (notification.getFeatureID(SCACoreRoot.class)) {
         case SCAPackage.SCA_CORE_ROOT__SOURCE_URI:
         case SCAPackage.SCA_CORE_ROOT__TARGET_URI:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), false, true));
            return;
         case SCAPackage.SCA_CORE_ROOT__MIXED:
            fireNotifyChanged(new ViewerNotification(notification, notification
                  .getNotifier(), true, false));
            return;
      }
      super.notifyChanged(notification);
   }

   /**
    * This adds to the collection of
    * {@link org.eclipse.emf.edit.command.CommandParameter}s describing all of
    * the children that can be created under this object. <!-- begin-user-doc
    * --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected void collectNewChildDescriptors(Collection newChildDescriptors,
         Object object) {
      super.collectNewChildDescriptors(newChildDescriptors, object);

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Comment(), ""))); //$NON-NLS-1$

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text(), ""))); //$NON-NLS-1$

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_AbstractComponent(),
            SCAFactory.eINSTANCE.createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_AbstractComponent(),
            SCAFactory.eINSTANCE.createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Binding(), SCAFactory.eINSTANCE
                  .createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Binding(), SCAFactory.eINSTANCE
                  .createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Binding(), SCAFactory.eINSTANCE
                  .createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Binding(), SCAFactory.eINSTANCE
                  .createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingSca(),
            SCAFactory.eINSTANCE.createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Component(),
            SCAFactory.eINSTANCE.createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_ComponentType(),
            SCAFactory.eINSTANCE.createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Composite(),
            SCAFactory.eINSTANCE.createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Composite(),
            SCAFactory.eINSTANCE.createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Composite(),
            SCAFactory.eINSTANCE.createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Composite(),
            SCAFactory.eINSTANCE.createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Implementation(),
            SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Implementation(),
            SCAFactory.eINSTANCE.createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Implementation(),
            SCAFactory.eINSTANCE.createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract(),
            SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationUnknown(),
            SCAFactory.eINSTANCE.createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Interface(),
            SCAFactory.eINSTANCE.createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Interface(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Interface(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Module(), SCAFactory.eINSTANCE
                  .createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_ModuleComponent(),
            SCAFactory.eINSTANCE.createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_ModuleFragment(),
            SCAFactory.eINSTANCE.createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_ModuleFragment(),
            SCAFactory.eINSTANCE.createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Source(), SCAFactory.eINSTANCE
                  .createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_SourceUri(), ""))); //$NON-NLS-1$

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Subsystem(),
            SCAFactory.eINSTANCE.createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_Target(), SCAFactory.eINSTANCE
                  .createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createAbstractImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createComponentType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createComposite())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createEntryPoint())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createExternalService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createImplementationComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleFragment())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModule())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleComponent())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleReference())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleService())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createModuleWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createProperty())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createPropertyValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createPropertyValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createReferenceValue())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createReferenceValuesSet())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSCABinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSLSBBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSubsystem())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createSystemWire())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createUnknownImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_TargetUri(), ""))); //$NON-NLS-1$

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_InterfaceWsdl(),
            SCAFactory.eINSTANCE.createWSDLPortType())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_InterfaceJava(),
            SCAFactory.eINSTANCE.createJavaInterface())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingWs(),
            SCAFactory.eINSTANCE.createWebServiceBinding())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationJava(),
            SCAFactory.eINSTANCE.createJavaImplementation())));

      newChildDescriptors.add(createChildParameter(SCAPackage.eINSTANCE
            .getSCACoreRoot_Mixed(), FeatureMapUtil.createEntry(
            SCAPackage.eINSTANCE.getSCACoreRoot_BindingEjb(),
            SCAFactory.eINSTANCE.createSLSBBinding())));
   }

   /**
    * This returns the label text for
    * {@link org.eclipse.emf.edit.command.CreateChildCommand}. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public String getCreateChildText(Object owner, Object feature, Object child,
         Collection selection) {
      Object childFeature = feature;
      Object childObject = child;

      if (childFeature instanceof EStructuralFeature
            && FeatureMapUtil.isFeatureMap((EStructuralFeature) childFeature)) {
         FeatureMap.Entry entry = (FeatureMap.Entry) childObject;
         childFeature = entry.getEStructuralFeature();
         childObject = entry.getValue();
      }

      boolean qualify = childFeature == SCAPackage.eINSTANCE
            .getSCACoreRoot_AbstractComponent()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Component()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Source()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_SourceEpr()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Target()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_TargetEpr()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ModuleComponent()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Binding()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_BindingSca()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_BindingEjb()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_BindingWs()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ComponentType()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Composite()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ModuleFragment()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Module()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Subsystem()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_Implementation()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationAbstract()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationJava()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_ImplementationUnknown()
            || childFeature == SCAPackage.eINSTANCE.getSCACoreRoot_Interface()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_InterfaceJava()
            || childFeature == SCAPackage.eINSTANCE
                  .getSCACoreRoot_InterfaceWsdl();

      if (qualify) {
         return getString("_UI_CreateChild_text2", //$NON-NLS-1$
               new Object[] { getTypeText(childObject),
                     getFeatureText(childFeature), getTypeText(owner) });
      }
      return super.getCreateChildText(owner, feature, child, selection);
   }

   /**
    * Return the resource locator for this item provider's resources. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   public ResourceLocator getResourceLocator() {
      return STPCorePlugin.INSTANCE;
   }

}
