/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.util;

import org.eclipse.core.runtime.IProgressMonitor;

public interface IModelLifecycle {

   int OPTION_NONE          = 0;

   int OPTION_FORCE         = 1 << 1;

   int OPTION_SAVE_ON_CLOSE = 1 << 2;

   /*
    * Save the changes; use OPTION_FORCE to force a save even if the underlying
    * resources are shared.
    */
   void save(int options, IProgressMonitor monitor)
         throws ModelLifecycleException;

   /*
    * Announce that you are finished with this lifecycle. Only calls which do
    * not return resources and do not modify internal state will be honored
    * after this call (e.g. isDisposed()).
    * 
    * Options could include OPTION_SAVE_ON_CLOSE to suggest a save() (only if
    * not shared) or OPTION_FORCE | OPTION_SAVE_ON_CLOSE to force a save even if
    * the underlying resources are not shared. --> The current impl in the
    * scribbler uses the IHumanInterfaceControllor if available to query for
    * guidance; otherwise for safety it calls save(false)
    * 
    */
   void close(int options, IProgressMonitor monitor)
         throws ModelLifecycleException;

   /*
    * Announce that you are finished with this lifecycle and that you do not
    * want your changes to be persisted. --> open to feedback about this
    * method's usefulness; currently it reverts all modifications (even for
    * shared resources) but perhaps the more correct semantic would be to revert
    * only unshared resources.
    */
   void discard(IProgressMonitor monitor) throws ModelLifecycleException;

   /*
    * Reset the state of the model are managed by the underlying framework with
    * the contents on disk
    */
   void revert(int options, IProgressMonitor monitor)
         throws ModelLifecycleException;

}
