/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.generators;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.LaunchUtil;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.cxf.launchers.JavaLaunchConfig;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.wizards.wsdltojava.WsdlToJavaGenerateAction;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class CxfJava2wsGenerator {
    private static final String TEMP_SRC_FOLDER_NAME = "tempFolder";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CxfJava2wsGenerator.class);
    private static CxfJava2wsGenerator instance = null;

    private CxfJava2wsGenerator() {
    }

    public static synchronized CxfJava2wsGenerator getInstance() {
        if (instance == null) {
            instance = new CxfJava2wsGenerator();
        }
        return instance;
    }

    public void run(IFile file, IProject project) throws CoreException {
        try {
            String verbose;
            String xsdImports;
            String genServer;
            IPreferenceStore preferenceStore = ScJaxWsPlugin.getDefault().getPreferenceStore();
            boolean mergeFlg = preferenceStore.getBoolean("KEY_MERGE");
            boolean isGenClient = false;
            boolean isGenServer = false;
            String tempFolderName = TEMP_SRC_FOLDER_NAME;
            while (project.getFolder(tempFolderName).exists()) {
                tempFolderName = String.valueOf(tempFolderName) + "1";
            }
            IFolder tempFolder = project.getFolder(tempFolderName);
            tempFolder.create(true, true, null);
            IJavaProject javaProject = JDTUtils.findJavaProject((String)project.getName());
            ArrayList<String> args = new ArrayList<String>();
            args.add("-databinding");
            args.add(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING));
            args.add("-frontend");
            if (project.hasNature("org.eclipse.stp.sc.jaxws.nature")) {
                args.add("jaxws");
            } else {
                args.add(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_FRONT_END));
            }
            String genWsdl = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL);
            if ("true".equalsIgnoreCase(genWsdl)) {
                IContainer wsdlLocation = JaxWsWorkspaceManager.getWSDLGenFolder(null, (IProject)project);
                String wsdlUrl = String.valueOf(wsdlLocation.getLocation().toOSString()) + File.separator + project.getName() + ".wsdl";
                args.add("-wsdl");
                args.add("-o");
                args.add(wsdlUrl);
            }
            args.add("-d");
            args.add(tempFolder.getLocation().toOSString());
            args.add("-s");
            args.add(tempFolder.getLocation().toOSString());
            args.add("-classdir");
            args.add(JaxWsWorkspaceManager.getClassesFolder((IProject)project).getLocation().toOSString());
            String genClient = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT);
            if ("true".equalsIgnoreCase(genClient)) {
                isGenClient = true;
                args.add("-client");
            }
            if ("true".equalsIgnoreCase(genServer = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER))) {
                args.add("-server");
                isGenServer = true;
            }
            args.add("-cp");
            args.add(JaxWsWorkspaceManager.getClassesFolder((IProject)project).getLocation().toOSString());
            String soap12 = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SOAP12);
            if (ToolConstants.PROPERTY_VALUE_SOAP12.equalsIgnoreCase(soap12)) {
                args.add("-soap12");
            }
            if ("true".equalsIgnoreCase(xsdImports = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT))) {
                args.add("-createxsdimports");
            }
            if ("true".equalsIgnoreCase(verbose = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_VERBOSE))) {
                args.add("-verbose");
            }
            args.add(JDTUtils.getJavaClassNameFromFile((IFile)file));
            LaunchUtil.launchJavaProgram((IJavaProject)javaProject, (String)"org.apache.cxf.tools.java2ws.JavaToWS", null, (String[])args.toArray(new String[0]), null);
            if (isGenServer || isGenClient) {
                this.generateLaunchConfiguration(isGenServer, isGenClient, tempFolder, project);
            }
            if (mergeFlg) {
                new WsdlToJavaGenerateAction().mergeDir(JaxWsWorkspaceManager.getSrcFolder((IProject)project).getLocation().toOSString(), tempFolder.getLocation().toOSString(), true);
            } else {
                new WsdlToJavaGenerateAction().mergeDir(JaxWsWorkspaceManager.getSrcFolder((IProject)project).getLocation().toOSString(), tempFolder.getLocation().toOSString(), false);
            }
            if (tempFolder.exists()) {
                tempFolder.delete(true, null);
            }
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("java to web service generation error with the start point: " + file), (Throwable)e);
        }
    }

    public void run(IProject project) throws CoreException {
        String fileName = project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT);
        IFile file = project.getFile((IPath)new Path(fileName));
        if (file != null && file.exists()) {
            this.run(file, project);
        }
    }

    private void createServerLaunchConfiguration(String configBaseName, String serverFullClassName, String progArgs, IProject project) {
        String projectName = project.getName();
        JavaLaunchConfig launchConfig = new JavaLaunchConfig();
        launchConfig.setProgramArgs(progArgs);
        launchConfig.setConfigBaseName(configBaseName);
        launchConfig.setProjectName(projectName);
        launchConfig.setServerMainClassName(serverFullClassName);
        launchConfig.createServerLaunchConfig();
    }

    private void createClientLaunchConfiguration(String configBaseName, String clientFullClassName, String progArgs, IProject project) {
        String projectName = project.getName();
        JavaLaunchConfig launchConfig = new JavaLaunchConfig();
        launchConfig.setProgramArgs(progArgs);
        launchConfig.setConfigBaseName(configBaseName);
        launchConfig.setProjectName(projectName);
        launchConfig.setClientMainClassName(clientFullClassName);
        launchConfig.createClientLaunchConfig();
    }

    private void generateLaunchConfiguration(boolean isGenServer, boolean isGenClient, IFolder tempFolder, IProject project) {
        try {
            String clientName = null;
            String serverName = null;
            String packageName = "";
            File tempFile = new File(tempFolder.getLocation().toOSString());
            File[] files = tempFile.listFiles();
            while (files != null && files.length > 0) {
                tempFile = files[0];
                if (tempFile.isFile()) break;
                packageName = packageName.length() > 0 ? String.valueOf(packageName) + "." + tempFile.getName() : tempFile.getName();
                files = files[0].listFiles();
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().endsWith("Client.java")) {
                    clientName = files[i].getName();
                }
                if (files[i].getName().endsWith("Server.java")) {
                    serverName = files[i].getName();
                }
                if (clientName != null && serverName != null) break;
                ++i;
            }
            if (packageName.length() > 0) {
                if (clientName != null) {
                    clientName = String.valueOf(packageName) + "." + clientName.substring(0, clientName.length() - 5);
                }
                if (serverName != null) {
                    serverName = String.valueOf(packageName) + "." + serverName.substring(0, serverName.length() - 5);
                }
            }
            if (isGenServer) {
                this.createServerLaunchConfiguration(project.getName(), serverName, null, project);
            }
            if (isGenClient) {
                this.createClientLaunchConfiguration(project.getName(), clientName, null, project);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while create launch configuration", (Throwable)ex);
        }
    }
}

