/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.cxf.wizard.Java2wsWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class Java2wsGenerateCodeAction implements
		IWorkbenchWindowActionDelegate {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(Java2wsGenerateCodeAction.class);
	
	public void dispose() {
		// TODO Auto-generated method stub

	}

	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub

	}

	public void run(IAction action) {
		try{
			IProject project = ResourceUtils.getActiveProject();
			Java2wsWizard wizard = new Java2wsWizard();
			wizard.setProject(project);
			Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
	        WizardDialog dialog = new WizardDialog(shell, wizard);
	        dialog.open();
	        project.refreshLocal(IResource.DEPTH_INFINITE, null);
		 } catch (Exception e) {
		      LOG.error("error during java to webservice generation", e);
		  }
	}

	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

}
