package org.eclipse.stp.sc.cxf.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.generators.CxfJava2wsGenerator;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class CxfJava2wsParameterPageContents implements IAdditionalPageContents {
	
	private static final String[] DATA_BINDING_OPTIONS = new String[]{ToolConstants.PROPERTY_VALUE_DATABINDING_JAXB, ToolConstants.PROPERTY_VALUE_DATABINDING_AEGIS};
	private static final String[] SOAP_OPTIONS = new String[]{ToolConstants.PROPERTY_VALUE_SOAP11, ToolConstants.PROPERTY_VALUE_SOAP12};
	
	//widgets
	protected Combo cmbDataBinding;
	protected Combo cmbSoap;
	protected Button btnWsdl;
	protected Button btnServer;
	protected Button btnClient;
	protected Button btnXsdImport;
	protected Button btnVerbose;
	
	private IProject project;
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(CxfJava2wsParameterPageContents.class);
	
	public IAdditionalPageContents getNextPageContents() {
		// TODO Auto-generated method stub
		//return new CopyOfCeltixJava2wsParameterPae();
		return null;
	}

	public Control createContents(Composite parent) {
		
		GridData gridData = new GridData(GridData.FILL_BOTH);
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayoutData(gridData);
		composite.setLayout(new GridLayout(1, false));
		
		
		Group grpPara = new Group(composite, SWT.NULL);
		grpPara.setLayout(new GridLayout(2, false));
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		grpPara.setLayoutData(gridData);
		grpPara.setText("CXF java2ws generator parameters");
		
		new Label(grpPara,SWT.NONE).setText("DataBinding");
		cmbDataBinding = new Combo(grpPara, SWT.READ_ONLY);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.FILL_HORIZONTAL);
		cmbDataBinding.setLayoutData(gridData);
		cmbDataBinding.setItems(DATA_BINDING_OPTIONS);
		
		new Label(grpPara,SWT.NONE).setText("SOAP");
		cmbSoap = new Combo(grpPara, SWT.READ_ONLY);
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.FILL_HORIZONTAL);
		cmbSoap.setLayoutData(gridData);
		cmbSoap.setItems(SOAP_OPTIONS);		
		
		btnWsdl = new Button(grpPara, SWT.CHECK);
		btnWsdl.setText("Generate WSDL");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		btnWsdl.setLayoutData(gridData);
		
		btnServer = new Button(grpPara, SWT.CHECK);
		btnServer.setText("Generate Server");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		btnServer.setLayoutData(gridData);
		
		btnClient = new Button(grpPara, SWT.CHECK);
		btnClient.setText("Generate Client");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		btnClient.setLayoutData(gridData);
		
		btnXsdImport = new Button(grpPara, SWT.CHECK);
		btnXsdImport.setText("Create XSD Import");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		btnXsdImport.setLayoutData(gridData);
		
		btnVerbose = new Button(grpPara, SWT.CHECK);
		btnVerbose.setText("Verbose");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		btnVerbose.setLayoutData(gridData);
		
		//set default value
		init();
		
		return composite;
	}

	public String getDescription() {
		// TODO Auto-generated method stub
		return "Specify java2ws generator parameters.";
	}

	public String getErrorMsg() {
		return null;
	}

	public String getPageName() {
		// TODO Auto-generated method stub
		return "CXF Java2ws Generator Parameter Page";
	}

	public String getTitle() {
		// TODO Auto-generated method stub
		return "CXF Java2ws Generator Parameter Page";
	}

	public boolean isPageValid() {
		return true;
	}

	public void performFinish() {
		try{
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING, cmbDataBinding.getText());
			project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION, cmbSoap.getText());
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, getTrueOrFalse(btnWsdl.getSelection()));
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, getTrueOrFalse(btnServer.getSelection()));
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, getTrueOrFalse(btnClient.getSelection()));
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT, getTrueOrFalse(btnXsdImport.getSelection()));
			project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_VERBOSE, getTrueOrFalse(btnVerbose.getSelection()));
			
			project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
			CxfJava2wsGenerator.getInstance().run(project);
		}catch(Exception ex){
			LOG.error("error during setting java2ws parameters", ex);
		}

	}

	public void setChangeListener(IPageContentsChangeListener listener) {
		//no need to use listener
	}

	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		// TODO Auto-generated method stub

	}
	
	public void setProject(IProject project){
		this.project = project;
	}
	
	protected void init(){
		if(project == null){
			cmbDataBinding.setText(DATA_BINDING_OPTIONS[0]);
			cmbSoap.setText(SOAP_OPTIONS[0]);
			btnWsdl.setSelection(true);
			btnServer.setSelection(true);
			btnClient.setSelection(true);
			btnXsdImport.setSelection(false);
			btnVerbose.setSelection(false);
		}else{
			try{
				cmbDataBinding.setText(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING));
				cmbSoap.setText(project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION));
				btnWsdl.setSelection(getTrueOrFalse(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL)));
				btnServer.setSelection(getTrueOrFalse(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER)));
				btnClient.setSelection(getTrueOrFalse(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT)));
				btnXsdImport.setSelection(getTrueOrFalse(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT)));
				btnVerbose.setSelection(getTrueOrFalse(project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_VERBOSE)));
			}catch(Exception ex){
				LOG.error(ex);
			}
		}
		cmbDataBinding.setEnabled(false);
	}

	private boolean getTrueOrFalse(String arg){
		boolean returnValue = false;
		if(arg != null &&
				arg.trim().equalsIgnoreCase(ToolConstants.PROPERTY_VALUE_TRUE)){
			returnValue = true;
		}
		return returnValue;
	}
	
	private String getTrueOrFalse(boolean arg){
		if(arg){
			return ToolConstants.PROPERTY_VALUE_TRUE;
		}else{
			return ToolConstants.PROPERTY_VALUE_FALSE;
		}
	}
}
