package org.eclipse.stp.sc.cxf.wizard;

import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.CXFResources;
import org.eclipse.stp.sc.cxf.natures.CxfNature;
import org.eclipse.stp.sc.jaxws.wizards.AbstractStartingPointPageContents;

public class CxfStartingPointPageContents extends AbstractStartingPointPageContents {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(CxfStartingPointPageContents.class);
	
	public static final String PAGE_NAME = "CXF Starting Point Page";
	
	public String getDescription() {
		return CXFResources.getString("Wizard.CXF.Startpoint.Page.Description");
	}

	public String getPageName() {
		return PAGE_NAME;
	}

	public String getTitle() {
		return CXFResources.getString("Wizard.CXF.Startpoint.Page.Title");
	}
	
	public void performFinish() {
		try{
			CxfNature.addToProject(project);
		}catch(Exception ex){
			LOG.error("error while add CXF nature to project", ex);
		}
	}
	
	public boolean getNeedAddWebMethodAnnotations(){
		//it's no need to add default WebMethod annotations to the methods defined in SEI
		return false;
	}
	
	
}
