/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.cxf.wizard.simplefe;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.wizards.StartingPointWizardPage;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class StartingPointWizardPageSimple extends StartingPointWizardPage {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(StartingPointWizardPageSimple.class);
	
	public StartingPointWizardPageSimple(String pageName) {
    	super(pageName);
    }
	
    public void performFinish(IProject project){
    	super.performFinish(project);
    	
    	try{
        	String originalFile = pageContents.getStartingPoint();
        	IFile targetFile = JDTUtils.importJavaFileToProject(originalFile, JaxWsWorkspaceManager.getSrcFolder(project));
    		importDependencies(project);
    		addExternalLibraries(project);
    		project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT, targetFile.getProjectRelativePath().toOSString());
    	}catch(Exception ex){
    		LOG.error("error during import the starting point", ex);
    	}
    }

}
