/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.FacetUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectNature;

public class JaxWsFacetInstallDelegate extends J2EEFacetInstallDelegate
		implements IDelegate {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxWsFacetInstallDelegate.class);
	
	public static String MODULE_TYPE = "stp.jaxws.component";
    public static String MODULE_VERSION = "2.0";
    
    
    
    /**
     * we need to add jst web facet to our jax-ws project.
     * otherwise, can't deploy the project to Tomcat server. (war based deploy will still work in that case)
     */
    
    	
    
	public void execute(IProject project, IProjectFacetVersion fv,
			Object config, IProgressMonitor monitor) throws CoreException {
		if (monitor != null) {
			monitor.beginTask("Installing JAX-WS facet", 1);
		}

		try {
//			IDataModel model = (IDataModel) config;

			final IJavaProject jproj = JavaCore.create(project);

			// Add WTP natures.
			WtpUtils.addNatures(project);

			// Setup the flexible project structure.
			final IVirtualComponent c = ComponentCore.createComponent(project);
			c.create(0, null);
			c.setMetaProperty("java-output-path", "/classes/");

			final IVirtualFolder jaxwsRoot = c.getRootFolder();
			// Create directory structure
			String srcFolder = null;
			jaxwsRoot.createLink(new Path("/src"), 0, null);
			jaxwsRoot.createLink(new Path("/wsdl"), 0, null);
			jaxwsRoot.createLink(new Path("/Webcontext/WEB-INF"), 0, null);
			jaxwsRoot.createLink(new Path("/Webcontext/META-INF/lib"), 0, null);
			if (monitor != null) {
				monitor.worked(1);
			}
		}

		finally {
			if (monitor != null) {
				monitor.done();
			}
		}

	}
	
	public static void addJaxWsFacet(IProject project) {
		try {
			WtpUtils.addNatures(project);
			FacetUtils.addFacetNature(project);
			
			//add java facet is doens't exists
			FacetUtils.addFacet(project, 
					FacetUtils.JAVA_FACET, 
					FacetUtils.JAVA_FACET_VERSION);
/*			FacetUtils.addFacet(project, 
					FacetUtils.JAVAWEB_FACET, 
					FacetUtils.JAVAWEB_FACET_VERSION);*/
			//add jax-ws facet
			FacetUtils.addFacet(project, MODULE_TYPE, MODULE_VERSION);
			
		} catch (Exception e) {
			e.printStackTrace();
			LOG.error("error when setup jaxws facet.", e);
		}
	}

}
