/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWizardPageContentsBase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @author qhuang
 *
 */
public class WizardPageBase<T extends IWizardPageContentsBase> extends WizardPage implements IPageContentsChangeListener{


	/**
	 * the current runtime type that this page is generated
	 * is it is changed. we need to redraw the control
	 */
	
	protected T pageContents;
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(WizardPageBase.class);
    
    public WizardPageBase(String pageName, T pageContents) {
        super(pageName);
        this.pageContents = pageContents;
    }

    protected Composite createPage(Composite parent) {
    	pageContents.createContents(parent);
        return parent;
    }
    
    public void createControl(Composite parent){
    	Composite pageComposite = new Composite(parent, SWT.NONE);
    	pageComposite.setLayoutData(new GridData(GridData.FILL_BOTH));
    	pageComposite.setLayout(new GridLayout(1, false));
    	setControl(pageComposite);
    	if(pageContents != null){
    		createPage(pageComposite); 
            setTitle(pageContents.getTitle());
            setDescription(pageContents.getDescription());
            validatePage();
    	}
    }
    
    public boolean validatePage() {
		setMessage(null);
		setErrorMessage(null);
		if (pageContents.isPageValid()) {
			setPageComplete(true);
		    return true;
		} else {
			setPageComplete(false);
			setErrorMessage(pageContents.getErrorMsg());
			return false;
        }
	}
	
	public void whenValidStatusChanged(){
		validatePage();
	}
	
	public void performFinish(IProject project){
		pageContents.setProject(project);
		pageContents.performFinish();
	}
    
	public void setPageContents(T pageContents){
		this.pageContents = pageContents;
		if(pageContents != null){
			pageContents.setChangeListener(this);
		}
	}
	
    /**
     * update the page control according to runtime selection.
     * dispose previous page control
     */
    public void updateControl() {
    	if(pageContents != null){
        	Control curComposite = getControl();
        	Composite parent = curComposite.getParent();
        	Composite pageComposite = new Composite(parent, SWT.NONE);
        	GridData gridData = new GridData();
    		gridData.horizontalAlignment = GridData.FILL;
    		gridData.grabExcessVerticalSpace = true;
    		gridData.grabExcessHorizontalSpace = true;
    		gridData.verticalAlignment = GridData.FILL;
        	pageComposite.setLayoutData(gridData);
        	pageComposite.setLayout(new GridLayout(1, false));
        	createPage(pageComposite); 
        	setControl(pageComposite);
            setTitle(pageContents.getTitle());
            setDescription(pageContents.getDescription());

        	parent.layout();
        	curComposite.dispose();
        	pageContents.setChangeListener(this);
        	
        	validatePage();
    	}else{
    		LOG.error("null page contents to be updated");
    	}
    	
    }
    

}
