/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.facet.JaxWsFacetInstallDelegate;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IEnableJaxwsHook;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;

public class EnableWizardBase extends Wizard {
	

	private static final LoggingProxy LOG = LoggingProxy.getlogger(EnableWizardBase.class);
	
	public static final String RUNTIME_PAGE = "runtimePage";
	
	IProject project;
	RuntimeSelectionPage runtimeSelectionPage;
	
	public EnableWizardBase(IProject project){
		this.project = project;
	}
	
	public void addPages(){
		RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
		if(!runtimeMgr.getUseDefaultRuntime()){
			runtimeSelectionPage = new RuntimeSelectionPage(RUNTIME_PAGE, 
		    		ScJaxWsResources.getString("runtimepage.title"), null);
		    addPage(runtimeSelectionPage);
		}
	}
	
	public boolean performFinish(){
		try{
            //setup jaxws facet
            JaxWsFacetInstallDelegate.addJaxWsFacet(project);
			
			//add runtime info
			RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
			String runtimeType = null;
			String runtimeID = null;
			if(!runtimeMgr.getUseDefaultRuntime()){
				RuntimeCore.setRuntimeType(project, runtimeType = runtimeSelectionPage.getRuntimeType());
				RuntimeCore.setRuntimeID(project, runtimeID = runtimeSelectionPage.getRuntimeID());
			}else{
				RuntimeCore.setRuntimeType(project, runtimeType = runtimeMgr.getDefaultRuntimeType());
				RuntimeCore.setRuntimeID(project, runtimeID = runtimeMgr.getDefaultRuntimeID());
			}

			//add JAXWS nature
			ScNature.addToProject(project, null);
			
			//do another process
			doAnother();
			
			//invoke the runtime hook
			IEnableJaxwsHook enableHook = runtimeMgr.getEnableJaxwsHook(runtimeType);
			if(enableHook != null){
				enableHook.run(project);
			}
		}catch(Exception ex){
			LOG.error("error whilc enabling jaxws", ex);
			return false;
		}
		return true;
	}
	
	protected void doAnother(){
		//do nothing as default
	}
}
