/*******************************************************************************
 * Copyright (c) 2006 IONA Technologies PLC
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IONA Technologies PLC - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.wsdltojava;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.ui.IWorkbench;

public class GenerateCodeWizard extends AbstractScWizard {
	private static final LoggingProxy LOG = LoggingProxy
			.getlogger(GenerateCodeWizard.class);

	public static final String DATA_PROJECT = "DATA_PROJECT";

	public static final String DATA_GEN_PARAMS = "DATA_GEN_PARAMS";

	public static final String DATA_WSDL_FILE = "DATA_WSDL_FILE";

	public static final String DATA_NEW_BUILD_PATH = "DATA_NEW_BUILD_PATH";

	

	// page identifiers used by this wizard
	public static final String GENERAL_PAGE = "generalPage";

	GeneralInfoPage genPage;

	Object wsdlSrc = null;
	
	public GenerateCodeWizard() {
		super();

		String title = ScJaxWsResources
				.getString("WsdlToJava.GenerateCodeWizard.Title");
		setWindowTitle(title);

		// set up active project for use by pages
		((HashMap<String, Object>) wizardData).put(DATA_PROJECT, ResourceUtils
				.getActiveProject());

		// set up an initial params
		Hashtable<String, Object> genParams = new Hashtable<String, Object>();
		((HashMap<String, Object>) wizardData).put(DATA_GEN_PARAMS, genParams);
	}

	public GenerateCodeWizard(StructuredSelection selection) {
//		super();
//
//		String title = ScJaxWsResources
//				.getString("WsdlToJava.GenerateCodeWizard.Title");
//		setWindowTitle(title);
//
//		// set up active project for use by pages
//		((HashMap<String, Object>) wizardData).put(DATA_PROJECT, ResourceUtils
//				.getActiveProject());
//
//		if (selection != null) {
//			((HashMap<String, Object>) wizardData).put(DATA_WSDL_FILE,
//					selection);
//		}
//		// set up an initial params
//		Hashtable<String, Object> genParams = new Hashtable<String, Object>();
//		((HashMap<String, Object>) wizardData).put(DATA_GEN_PARAMS, genParams);
		this();
		setSelection(selection);
	}
	
	public void setSelection(StructuredSelection selection) {
		if (selection != null) {
			((HashMap<String, Object>) wizardData).put(DATA_WSDL_FILE,
					selection);
		}
		
	}

	public GenerateCodeWizard(IProject targetProject,
			StructuredSelection selection) {
		this(selection);
		// set up active project for use by pages
		((HashMap<String, Object>) wizardData).put(DATA_PROJECT, targetProject);
	}

	public void addPages() {
		genPage = new GeneralInfoPage(this, GENERAL_PAGE, null);
		addPage(genPage);
	}
	
	public boolean canFinish() {
        return true;
    }
	

	@Override
	public boolean performFinish() {
		try {
			genPage.applyToData(genPage.getWizardData());
			IProject theProject = ResourceUtils.getActiveProject();
            WsdlToJavaGenerateAction action = new WsdlToJavaGenerateAction();
            IPath wsdlPath = ResourceUtils.getSelectedResource().getFullPath();
            IFile wsdlFile = theProject.getWorkspace().getRoot().getFile(wsdlPath);
            action.generate(wsdlFile.getRawLocation().toOSString(),
					theProject, wizardData.get(DATA_GEN_PARAMS));
			IPath[] nPaths = (IPath[]) wizardData.get(DATA_NEW_BUILD_PATH);
			updateProjectSrcPaths(theProject, nPaths);

		} catch (Exception ce) {
			ce.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * Add the code path to the java build paths if it's new.
	 */
	private void updateProjectSrcPaths(IProject project, IPath[] paths) {
		IJavaProject javaProject = JavaCore.create(project);
		ArrayList<IClasspathEntry> allEntries = new ArrayList<IClasspathEntry>();

		try {
			IClasspathEntry[] entries = javaProject.getRawClasspath();
			if (entries != null) {
				for (int i = 0; i < entries.length; ++i) {
					allEntries.add(entries[i]);
				}
			}
			if (paths != null) {
				for (int i = 0; i < paths.length; ++i) {
					IClasspathEntry newEntry = JavaCore
							.newSourceEntry(paths[i]);
					allEntries.add(newEntry);
				}
			}
			javaProject.setRawClasspath((IClasspathEntry[]) allEntries
					.toArray(new IClasspathEntry[0]), null);
		} catch (JavaModelException e) {
			LOG.debug("Error updating source path for project.", e);
		}

	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// TODO Auto-generated method stub
	}

	

	
}
