/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.validator;

import java.util.ArrayList;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiErrorHandler
implements ErrorHandler {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(MultiErrorHandler.class);
    private static final String ERROR_MSG_PREFIX = "The value";
    private ArrayList<SAXParseException> errorList = new ArrayList();
    private int errorCount = 0;
    StringBuffer errorMsg = new StringBuffer();

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.addError(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.addError(exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    public ArrayList<SAXParseException> getAllErrors() {
        return this.errorList;
    }

    private void addError(SAXParseException ex) {
        LOG.debug((Object)("parser add error:" + ex));
        ++this.errorCount;
        this.errorList.add(ex);
        this.errorMsg.append(this.parseErrorMsg(ex.getMessage()));
    }

    private String parseErrorMsg(String msg) {
        if (msg.indexOf(ERROR_MSG_PREFIX) > 0 && msg.indexOf("is not valid") > 0) {
            return msg.substring(msg.indexOf(ERROR_MSG_PREFIX));
        }
        return "";
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public String getErrorMsg() {
        return this.errorMsg.toString();
    }

    public void reset() {
        this.errorCount = 0;
        this.errorMsg = new StringBuffer();
        this.errorList.clear();
    }
}

