/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtime.UpdatedClasspathContainer;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class RuntimeUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeUtils.class);
    private static IJavaProject fDummyProject = RuntimeUtils.createPlaceholderProject();

    public static String[] getLibEntryInManifest(String jarFileName) {
        File facadeFile = new File(jarFileName);
        ArrayList<String> libs = new ArrayList<String>();
        try {
            JarFile facadeJar = new JarFile(facadeFile);
            Manifest mfst = facadeJar.getManifest();
            Attributes attrs = mfst.getMainAttributes();
            String path = attrs.getValue("Class-Path");
            StringTokenizer tkzr = new StringTokenizer(path);
            String libEntry = null;
            while (tkzr.hasMoreTokens()) {
                libEntry = tkzr.nextToken();
                libs.add(libEntry);
            }
        }
        catch (IOException e) {
            LOG.debug((Object)"Exception getting jar facade", (Throwable)e);
        }
        return libs.toArray(new String[0]);
    }

    public static String[] getLibEntryByDir(String path) {
        File dir = new File(path);
        ArrayList<String> libs = new ArrayList<String>();
        if (!dir.exists() || !dir.isDirectory()) {
            return new String[0];
        }
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.endsWith(".jar")) {
                libs.add(fileName);
            }
            ++n2;
        }
        return libs.toArray(new String[0]);
    }

    public static IClasspathEntry getRuntimeLib(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        String runtimeLibName = RuntimeUtils.getRuntimeLibName(runtime);
        IClasspathEntry cpEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.stp.sc.SOA_Runtime_Libraries").append(runtimeLibName), (boolean)true);
        return cpEntry;
    }

    public static IClasspathEntry createRuntimeLib(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        IClasspathEntry cpEntry = null;
        String runtimeLibName = RuntimeUtils.getRuntimeLibName(runtime);
        IPath path = new Path("org.eclipse.stp.sc.SOA_Runtime_Libraries").append(runtimeLibName);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.stp.sc.SOA_Runtime_Libraries");
        try {
            UpdatedClasspathContainer container = new UpdatedClasspathContainer(runtime);
            initializer.requestClasspathContainerUpdate(path, fDummyProject, (IClasspathContainer)container);
            JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{fDummyProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
            RuntimeUtils.rebindClasspathEntries(path, container, null);
        }
        catch (CoreException ex) {
            LOG.error((Object)("error while creating the runtime library " + runtimeLibName + "in User Libraries"), (Throwable)ex);
        }
        return cpEntry;
    }

    public static void removeRuntimeLib(IRuntime runtime) {
        if (runtime == null) {
            return;
        }
        String runtimeLibName = RuntimeUtils.getRuntimeLibName(runtime);
        try {
            IPath path = new Path("org.eclipse.stp.sc.SOA_Runtime_Libraries").append(runtimeLibName);
            RuntimeUtils.rebindClasspathEntries(path, null, null);
        }
        catch (CoreException ex) {
            LOG.error((Object)("error while removing the runtime library " + runtimeLibName + "in User Libraries"), (Throwable)ex);
        }
    }

    public static String getRuntimeLibName(IRuntime runtime) {
        String retValue = null;
        if (runtime != null) {
            retValue = String.valueOf(runtime.getRuntimeType().getName()) + " Library [" + runtime.getId() + "]";
        }
        return retValue;
    }

    public static IRuntime getRuntimeFromLibName(String name) {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        if (runtimes != null && runtimes.length > 0) {
            IRuntime[] iRuntimeArray = runtimes;
            int n = runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                String libName = RuntimeUtils.getRuntimeLibName(runtime);
                if (libName != null && libName.equals(name)) {
                    return runtime;
                }
                ++n2;
            }
        }
        return null;
    }

    private static IJavaProject createPlaceholderProject() {
        IProject project;
        IJavaProject retValue = null;
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        while (true) {
            if (!(project = root.getProject(name)).exists()) break;
            name = String.valueOf(name) + '1';
        }
        retValue = JavaCore.create((IProject)project);
        return retValue;
    }

    public static void rebindClasspathEntries(IPath containerPath, IClasspathContainer container, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (monitor != null) {
                monitor.beginTask("", 1);
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
            ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>();
            int i = 0;
            while (i < projects.length) {
                IJavaProject project = projects[i];
                IClasspathEntry[] entries = project.getRawClasspath();
                int k = 0;
                while (k < entries.length) {
                    IClasspathEntry curr = entries[k];
                    if (curr.getEntryKind() == 5 && containerPath.equals((Object)curr.getPath())) {
                        affectedProjects.add(project);
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            if (!affectedProjects.isEmpty()) {
                IJavaProject[] affected = affectedProjects.toArray(new IJavaProject[affectedProjects.size()]);
                IClasspathContainer[] containers = new IClasspathContainer[affected.length];
                if (container != null) {
                    containers[0] = container;
                }
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])affected, (IClasspathContainer[])containers, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 1)));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

