package org.eclipse.stp.sc.common.runtime;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stp.sc.common.utils.RuntimeUtils;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeClasspathContainerInitializer extends
		ClasspathContainerInitializer {
	
	public static final String ID = "org.eclipse.stp.sc.SOA_Runtime_Libraries";

	@Override
	public void initialize(IPath containerPath, IJavaProject project)
			throws CoreException {
		if(containerPath.segment(0).equals(ID)){
			String libName = containerPath.lastSegment();
			IRuntime runtime = RuntimeUtils.getRuntimeFromLibName(libName);
			if(runtime != null){
				UpdatedClasspathContainer container = new UpdatedClasspathContainer(runtime);
				JavaCore.setClasspathContainer(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{container}, null);
			}
		}
	}
	
	public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion)throws CoreException {
		JavaCore.setClasspathContainer(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{containerSuggestion}, null); 
	}
	
	 public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project){
		 return true;
	 }

}
