/*******************************************************************************

* Copyright (c) 2007 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.common.utils;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/**
 * This class is utils class for IExtension
 * @author jma
 *
 */
public class ExtensionRegUtils {
    
    
    public static IExtensionPoint getExtensionPoint(String extensionPointId) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        return reg.getExtensionPoint(extensionPointId);
    }
    
    public static IConfigurationElement getConfigElem(IExtension ext, String configName, 
            String attribute, String value) {
        for (IConfigurationElement cfg : ext.getConfigurationElements()) {
            if (cfg.getName().equals(configName)) {
                if (attribute == null) {
                    return cfg;
                }
                if (cfg.getAttribute(attribute).equals(value)) {
                    return cfg;
                }
            }
        }
        return null;
    }

}
