/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.common.validator;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.eclipse.stp.sc.common.annotations.ext.AnnotationSupportProxy;
import org.w3c.dom.Document;

public class XMLUtils {
	private static String NS_PRIFIX = "http://";
	private static char SEPERATOR = '/';
	
	/**
	 * get namespace from the package name of this clas
	 * @param the full class name
	 * @return the namespace start with "http://"
	 */
	public static String getNSFromClsName(String clsFullName) {
		if (clsFullName.lastIndexOf(".") <0) {
			//it is simple name.
			Class cls = AnnotationSupportProxy.getAnnotationClass(clsFullName);
			clsFullName =  cls.getName();
		}
		String packageName = clsFullName.substring(0, clsFullName.lastIndexOf("."));
		StringBuffer ns = new StringBuffer();
		StringTokenizer st = new StringTokenizer(packageName, ".");
		while(st.hasMoreTokens()) {
			if (ns.length() > 0) {
				ns.insert(0,SEPERATOR);
			}
			ns.insert(0, st.nextToken());
		}
		ns.insert(0, NS_PRIFIX);
	    return ns.toString();	
	}
	
	public static String getFileNameFromNS(String namespace) {
		String name = namespace.substring(NS_PRIFIX.length());
		name.replace("/", "_");
		return name;
	}
	
	public static String getXMLAsString(Document doc) {
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		saveDocument(doc, bos);
		return bos.toString();
	}
	
	
	public static void saveDocument(Document document, OutputStream os) {
		try{
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
			DOMSource source = new DOMSource(document);
			StreamResult stream = new StreamResult(os);
			
			transformer.transform(source, stream);
 
		}catch(TransformerConfigurationException e){
			e.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		}
	}
	
	/** Saves the document as xml. */
	public static void saveDocument(Document document, String fileName){
		
		try{
			FileOutputStream fos = new FileOutputStream(fileName);
			saveDocument(document, fos);
    
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
