package org.eclipse.stp.sc.common.runtime;

import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.stp.sc.common.utils.RuntimeUtils;
import org.eclipse.wst.server.core.IRuntime;

public class UpdatedClasspathContainer implements IClasspathContainer {

	private IRuntime runtime;
	public UpdatedClasspathContainer(IRuntime runtime){
		this.runtime = runtime;
	}
	
	public IClasspathEntry[] getClasspathEntries() {
		IExtRuntimeProcessor processor = ExtRuntimeManager.getInstance().getExtendedRuntimeProcessor(runtime.getRuntimeType().getId());
		if(processor != null){
			List<IClasspathEntry> entries = processor.getRuntimeClasspathEntry(runtime);
			if(entries != null){
				return entries.toArray(new IClasspathEntry[]{});
			}
		}
		return null;
	}

	public String getDescription() {
		return RuntimeUtils.getRuntimeLibName(runtime);
	}

	public int getKind() {
		return IClasspathContainer.K_APPLICATION;
	}

	public IPath getPath() {
		return new Path(RuntimeClasspathContainerInitializer.ID).append(RuntimeUtils.getRuntimeLibName(runtime));
	}

}
