/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IRuntimeDefinition;
import org.eclipse.stp.soas.deploy.core.IRuntimeType;
import org.eclipse.stp.soas.deploy.core.ISupportedRuntimeType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.MatchRule;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;

public class SupportedRuntimeType
implements ISupportedRuntimeType {
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_MIN_VERSION = "minVersion";
    public static final String ATTR_MAX_VERSION = "maxVersion";
    public static final String ATTR_MATCH_RULE = "matchRule";
    private IConfigurationElement mElement;
    private String mRuntimeDef;
    private IVersion mMinVersion;
    private IVersion mMaxVersion;
    private MatchRule mMatchRule;

    public SupportedRuntimeType(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
    }

    public SupportedRuntimeType(String runtimeDef, IVersion minVersion, IVersion maxVersion, MatchRule matchRule) {
        this.mRuntimeDef = runtimeDef;
        this.mMinVersion = minVersion;
        this.mMaxVersion = maxVersion;
        this.mMatchRule = matchRule;
    }

    public IRuntimeDefinition getRuntimeDefinition() {
        return DeploymentExtensionManager.getInstance().getRuntimeDefinition(this.mRuntimeDef);
    }

    public IVersion getMinVersion() {
        return this.mMinVersion;
    }

    public IVersion getMaxVersion() {
        return this.mMaxVersion;
    }

    public MatchRule getVersionMatchRule() {
        return this.mMatchRule;
    }

    public boolean supportsRuntime(IRuntimeType type) {
        IVersion typeVersion = type.getVersion();
        return type.getRuntimeDefinition().equals(this.getRuntimeDefinition()) && typeVersion.compareTo(this.getMinVersion()) >= 0 && (typeVersion.compareTo(this.getMaxVersion()) <= 0 || this.getMaxVersion().isCompatibleWithVersion(typeVersion, this.getVersionMatchRule()));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.mMinVersion.equals(this.mMaxVersion)) {
            buf.append(this.mMinVersion);
        } else {
            buf.append(this.mMinVersion).append('-').append(this.mMaxVersion);
        }
        return DeployCorePlugin.getDefault().getResourceString("SupportedServerType.toString", new Object[]{this.mRuntimeDef, buf.toString(), this.mMatchRule});
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        Assert.isTrue((boolean)"supportedRuntime".equals(element.getName()));
        if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.out.println(DeployCorePlugin.getDefault().getResourceString("SupportedServerType.trace.processingSupportedServer", new Object[]{element.getDeclaringExtension().getContributor().getName(), ((IConfigurationElement)element.getParent()).getName()}));
        }
        boolean error = false;
        this.mElement = element;
        this.mRuntimeDef = this.mElement.getAttribute(ATTR_TYPE);
        this.mMinVersion = Version.valueOf(this.mElement.getAttribute(ATTR_MIN_VERSION));
        this.mMaxVersion = Version.valueOf(this.mElement.getAttribute(ATTR_MAX_VERSION));
        String matchRule = this.mElement.getAttribute(ATTR_MATCH_RULE);
        if (matchRule == null || MatchRule.valueOf(matchRule.trim()) == null) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.out.println(DeployCorePlugin.getDefault().getResourceString("SupportedServerType.trace.warning.matchRuleNotSpecified"));
                System.out.flush();
            }
            this.mMatchRule = MatchRule.EQUIVALENT;
        } else {
            this.mMatchRule = MatchRule.valueOf(matchRule.trim());
        }
        if (this.mRuntimeDef == null) {
            error = true;
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedServerType.trace.error.typeNotSpecified"));
                System.err.flush();
            }
        } else if (DeploymentExtensionManager.getInstance().getRuntimeDefinition(this.mRuntimeDef) == null) {
            error = true;
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedServerType.trace.error.invalidTypeSpecified"));
                System.err.flush();
            }
        }
        if (this.mMinVersion.compareTo(this.mMaxVersion) > 0) {
            error = true;
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedServerType.trace.error.minVersionGreaterThanMaxVersion"));
                System.err.flush();
            }
        } else if (this.mMaxVersion.compareTo(Version.NULL_VERSION) == 0 && DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedServerType.trace.error.versionsNotSet"));
            System.err.flush();
        }
        if (error) {
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("SupportedServerType.exception.supportedServerParseError"));
        }
    }
}

