/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.jaxwsri.core.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipes.stp.soas.deploy.runtime.jaxwsri.JaxwsRIRuntimePlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

/**
 * version hander for JAX-WS RI 2.1
 * 
 * @author jma
 *
 */
public class JaxwsRI21VersionHandler implements IJaxwsRIVersionHandler {

	private static String LIB_DIR_NAME = "lib";
	
	/**
	 * get the classpath defined from cxf facade jar 
	 */
	public List<IRuntimeClasspathEntry> getRuntimeClasspath(IPath installPath) {
		List<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
		String libPath = installPath.append(LIB_DIR_NAME).makeAbsolute().toOSString();
		String[] jars = RuntimeUtils.getLibEntryByDir(libPath);
		for (String libName : jars) {
			IPath path = installPath.append(LIB_DIR_NAME).append(libName);
			cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry(path));
		}
		return cp;
	}
	
	
	public boolean verifyInstallPath(IPath installPath) {
		if (installPath == null)
			return false;

		return JaxwsRIRuntimePlugin.verifyInstallPath(installPath);
	}
	
	

}
