/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.editors.GeneralInfoSection;
import org.eclipse.stp.soas.internal.deploy.ui.editors.PackagesSection;
import org.eclipse.stp.soas.internal.deploy.ui.editors.ServersSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class OverviewPage
extends EMFFormPage {
    public static final String PAGE_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTITLE.Overview");
    private GeneralInfoSection mGeneralInfo;
    private PackagesSection mPackages;
    private ServersSection mServers;

    public OverviewPage(EMFFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(PAGE_TITLE);
        GridLayout layout = EnhancedFormEditor.newPageGridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)layout);
        this.mGeneralInfo = new GeneralInfoSection(form.getBody(), toolkit, 384);
        this.mGeneralInfo.createClient(toolkit);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.mGeneralInfo.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.mGeneralInfo);
        this.mPackages = new PackagesSection(form.getBody(), toolkit, 384);
        this.mPackages.createClient(toolkit);
        gd = new GridData(1808);
        this.mPackages.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.mPackages);
        this.mServers = new ServersSection(form.getBody(), toolkit, 384);
        this.mServers.createClient(toolkit);
        gd = new GridData(1808);
        this.mServers.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.mServers);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, IHelpConstants.CONTEXT_ID_OVERVIEW_PAGE);
    }
}

