/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.stp.soas.deploy.core.ui.configuration.IConfigurationPageFactory;


/**
 * This object is used for managing IPackageConfiguration objects.  This object
 * serves as a factory/serializer for managing configuration information for
 * specific physical package types.
 * 
 * @author rcernich
 *
 * Created on Mar 23, 2004
 */
public interface IPackageConfigurationManager {
	
	/**
	 * Initializes this configuration manager with its contributor.
	 * 
	 * @param extension the extension contributing this object.
	 */
	void init(IConfigurablePackageExtension extension);
	
	/**
	 * Returns the extension that contributed this object.
	 * 
	 * @return the extension that contributed this object.
	 */
	IConfigurablePackageExtension getConfigurablePackageExtension();
	
	/**
	 * Creates a new package configuration for the specified logical package
	 * that adheres to the specified server version.
	 * 
	 * @param pkg the logical package to generate configuration information for.
	 * 
	 * @return a new package configuration object.
	 */
	IPackageConfiguration createPackageConfiguration(IServiceDescriptor pkg);
	
	/**
	 * Creates a package configuration object from the data in the stream.
	 * 
	 * @param pkg the package the configuration is associated with.
	 * @param is the input stream containing the data for the configuration.
	 * 
	 * @return the configuration object with settings as specified by the stream.
	 */
	IPackageConfiguration createPackageConfiguration(IServiceDescriptor pkg, InputStream is) throws IOException;
	
	/**
	 * Serializes a configuration object into the specified output stream.
	 * This enables the framework to persist configuration information.
	 * 
	 * @param configuration the configuration information to serialize.
	 * @param os the stream to serialize the data in.
	 */
	void serializePackageConfiguration(IPackageConfiguration configuration, OutputStream os) throws IOException;
	
	/**
	 * Returns an IConfigurationPageFactory.  This factory is used by the deployment
	 * editor to populate the property dialog used to edit a package
	 * configuration.
	 * 
	 * @return a property page factory.
	 */
	IConfigurationPageFactory getConfigurationPageFactory();

}
