/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.util.List;

import org.eclipse.core.runtime.CoreException;

/**
 * @author rcernich
 * 
 * Created on Nov 2, 2004
 */
public interface IPackageConstructor {

	/**
	 * Creates a package based on the information contained in the file, using
	 * the specified configuration information.
	 * 
	 * @param pkg the package definition that should be used to create the
	 *        package
	 * @param context contextual information that may be used when generating
	 *        the package.
	 * @param configuration the configuration information that should be used
	 *        when generating this package, null if no configuration is
	 *        specified.
	 * 
	 * XXX: should look at passing a stream object into this method. This will
	 * allow us to control the output file. May also need to add support for
	 * identifying or specifying the output file for this package.
	 */
	List<IPackageOutputDescriptor> createPackage(IServiceDescriptor pkg,
			IPackageCreationContext context, IPackageConfiguration configuration)
			throws CoreException;

}