/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IServer;

/**
 * @author rcernich
 * 
 * Created on Nov 2, 2004
 */
public interface IPackageConstructorExtension extends IPackageConstructor {

	String getID();

	boolean supportsPackage(IServiceDescriptor pkg);
	
	boolean supportsServer(IServerType serverType);

	IStatus[] validatePackage(IServiceDescriptor pkg,
			IPackageConfiguration configuration, IDeployTarget target);

	ISupportedTechnologyType getSupportedTechnologyType();


	List<ISupportedRuntimeType>  getSupportedRuntimeType();

	List<ISupportedServerType> getSupportedServerType();
	
	IDeployTarget adaptServer(IServer server);
	
	String getName();
	
	boolean supportsTechnology(ITechnologyType type);
	boolean supportsRuntimeType(IRuntimeType type);  
}