/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.stp.soas.internal.deploy.core.TechnologyType;

/**
 * @author rcernich
 * 
 * Created on Mar 25, 2004
 */
public abstract class ServiceDescriptorBase extends PackageBase implements
		IServiceDescriptor {

	public ServiceDescriptorBase() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ILogicalPackage#getTechnologyType()
	 */
	public ITechnologyType getTechnologyType() {
		return new TechnologyType(
				((IServiceDescriptorExtension) getExtension())
						.getSupportedTechnologyType().getTechnologyDefinition()
						.getID(), getTechnologyVersion());
	}

	public IRuntimeType getRuntimeType(){
		
		ISupportedRuntimeType runtimeType = ((IServiceDescriptorExtension) getExtension())
		.getSupportedRuntimeType();
		if(runtimeType == null){
			return null;
		}
		return new RuntimeType(runtimeType.getRuntimeDefinition().getID(),
				getRuntimeVersion());
	}
	
	protected abstract Version getTechnologyVersion(); 
	
	protected abstract Version getRuntimeVersion();

}