/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.operations.CreatePackageJob;

/**
 * @author rcernich
 * 
 * Created on Jan 26, 2005
 */
public class CreatePackageFileAction extends Action {

	private IServiceDescriptor mPackage;
	private IPackageConstructorExtension mConstructor;
	private IPackageConfiguration mConfiguration;

	/**
	 * @param text
	 */
	public CreatePackageFileAction(String text) {
		super(text);
	}

	public CreatePackageFileAction(String text, IServiceDescriptor pkg,
									IPackageConstructorExtension constructor,
									IPackageConfiguration configuration) {
		this(text);
		mPackage = pkg;
		mConstructor = constructor;
		mConfiguration = configuration;
	}

	public CreatePackageFileAction(String text, IServiceDescriptor pkg,
									IPackageConstructorExtension constructor) {
		this(text, pkg, constructor, null);
	}

	/**
	 * @param configuration The configuration to set.
	 */
	public void setConfiguration(IPackageConfiguration configuration) {
		mConfiguration = configuration;
	}

	/**
	 * @param constructor The constructor to set.
	 */
	public void setConstructor(IPackageConstructorExtension constructor) {
		mConstructor = constructor;
	}

	/**
	 * @param package1 The package to set.
	 */
	public void setPackage(IServiceDescriptor pkg) {
		mPackage = pkg;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		CreatePackageJob createPackageOp = new CreatePackageJob(mPackage,
				mConstructor, mConfiguration);

		// Make sure any dirty files are saved.
		if (!DeployCorePlugin.getDefault().getWorkbench().saveAllEditors(
				true)) {
			return;
		}

		createPackageOp.schedule();
	}

}