/*******************************************************************************
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

/**
 * 
 * Factory class to create web module, which can be deployed to wtp server
 * 
 * @author jma
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.model.ModuleFactoryDelegate;

public class WTPServiceModuleFactory extends ModuleFactoryDelegate {

	
	public static String FACET_PROJECT_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
	public static String MODULE_TYPE = "jst.web";
    public static String MODULE_VERSION = "2.2";
    public static String MODULE_TYPE_JAXWS = "stp.jaxws.component";
    public static String MODULE_VERSION_JAXWS = "2.1";
    
    
    private List<IModule> moduleValues = new ArrayList<IModule>(); 
	
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WTPServiceModuleFactory.class);
    
	protected Map<IModule, ModuleDelegate> moduleDelegates = new HashMap<IModule, ModuleDelegate>(5);
	
	public WTPServiceModuleFactory() {
		super();
	}
	
	@Override
	public ModuleDelegate getModuleDelegate(IModule module) {
        return moduleDelegates.get(module);
	}

	@Override
	public IModule[] getModules() {
		
			moduleValues.clear();
			IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
			for(int i = 0; i < projects.length; i++){
//				boolean isJaxws;
//				try {
//					isJaxws = ScNature.hasNature(projects[i]);
//				} catch (CoreException e) {
//					continue;
//				} 
//				if(isJaxws){
					if (projects[i].isAccessible()) {
						getModulesByProject(projects[i]);
					}
//				}
			}
			
		
		return moduleValues.toArray(new IModule[moduleValues.size()]);
		
	}


	private void getModulesByProject(IProject project){
		IFile[] wars = findWarFileByProject(project);
		for(int i = 0; i < wars.length; i++){
			File warFile = new File(wars[i].getLocation().toOSString());
			//if the war file has been unziped, regard it as a module
			if(!warFile.exists()){
				continue;
			}
			IModule modules2 = createModule(project,null, MODULE_TYPE_JAXWS, MODULE_VERSION_JAXWS, warFile);
			if (modules2 != null)
				moduleValues.add(modules2);
		}
		
	}
	
	private IFile[] findWarFileByProject(IContainer container){
		List<IFile> wars = new ArrayList<IFile>();
		try {
			IResource[] res = container.members();
			for(int i = 0; i < res.length; i++){
				if (res[i] instanceof IFile
						&& res[i].getName().endsWith(".war")) {
					wars.add((IFile)res[i]);
				}
				else if(res[i] instanceof IContainer){
					wars.addAll(Arrays.asList(findWarFileByProject((IContainer)(res[i]))));					
				}
			}
			
			
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return wars.toArray(new IFile[wars.size()]);
		
	}
	/**
	 * Returns the workspace root.
	 * 
	 * @return the workspace root
	 */
	private static IWorkspaceRoot getWorkspaceRoot() {
		return ResourcesPlugin.getWorkspace().getRoot();
	}

	/**
	 * add facet nature to the project
	 * @param project
	 * @throws Exception
	 */
	private void addFacetNature(IProject project) throws  Exception {
		IProjectDescription projDesc = project.getDescription();
		String[] natures = projDesc.getNatureIds();
		String[] newNatures = new String[natures.length + 1];
		System.arraycopy(natures, 0, newNatures, 0, natures.length);
		newNatures[newNatures.length - 1] = FACET_PROJECT_NATURE;
		projDesc.setNatureIds(newNatures);
		project.setDescription(projDesc, null);
	}
	
	public IModule createModule(IProject project, IPackageOutputDescriptor desc, File warFile) {
		return createModule(project, desc, MODULE_TYPE, MODULE_VERSION, warFile);
	}
	
	private IModule createModule(IProject project, IPackageOutputDescriptor desc, String moduleType, String version, File warFile) {
		 
		try {
			
			//add faced nature
			if (!project.hasNature(FACET_PROJECT_NATURE)) {
				addFacetNature(project);
			}
			IProjectFacet pf = ProjectFacetsManager.getProjectFacet(MODULE_TYPE);
			IProjectFacetVersion fv = pf.getVersion(MODULE_VERSION);

			IFacetedProject facetedProject = ProjectFacetsManager.create(project);
			
			//add jst.web faced
			if (!facetedProject.hasProjectFacet(pf))  {
				LOG.debug("install jst.web facet");
			    facetedProject.installProjectFacet(fv, null, null);
			}
		} catch (CoreException ce) {
			//ignore it
		}
		catch (Exception e) {
			e.printStackTrace();
			LOG.error(e);
		}
		

		
		//need to change here. do not create moduledelegate this way. should get from somewhere.
		/*
		if (name.endsWith(".war")) {
			String docBase = name.substring(0, name.indexOf(".war"));
			docBase = docBase + "/" + name;
			name = docBase;
		}
		*/ 
	    IModule module = createStpModule(MODULE_TYPE, MODULE_VERSION, project, desc, warFile);

		ServiceModuleDelegate moduleDelegate = new ServiceModuleDelegate(
				project, desc);
		moduleDelegate.setModule(module);
		moduleDelegates.put(module, moduleDelegate);

		// call the validate,
		((Module) module).validate(null);
		return module;
	    
	}
	

	
	public String getModuleName(IPackageOutputDescriptor desc){
		String name=desc.getLogicalName();
		if(desc instanceof FilePackageOutputDescriptor){
			name = ((FilePackageOutputDescriptor)desc).getFile().getName();
		}
		
		if (name.endsWith(".war")) {
			name = name.substring(0, name.indexOf(".war"));
			
		}
		//name = name + FOLDER_EXT;	 
		
		return name;
	}
	
	/**
	 * over the createModule method to create stp module
	 * Sicne the creaetModule in super class is final, we use another name for override
	 * the factory attribute is private in super class, which is invisiable to us. Thus
	 * we use ServerPlugin.findModuleFactory to lookup the factory again 
	 */
	
	protected IModule createStpModule(String type, String version, IProject project, IPackageOutputDescriptor desc, File warFile) {
		String factorId = getId();
		ModuleFactory factory = ServerPlugin.findModuleFactory(factorId);
		//return new StpModule(factory, type, version, project, getModuleName(desc));
		String fileName = warFile.getName();
		if (fileName.endsWith(".war")) {
			fileName = fileName.substring(0, fileName.indexOf(".war"));
			
		}
		
		return new StpModule(factory, type, version, project, fileName, fileName, warFile);
	}
	

}
