/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.part;

import java.io.InputStream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.wizards.EditorWizardPage;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorUtil;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramFileCreator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class BpmnCreationWizardPage
extends EditorWizardPage {
    public static final String NATURE_ID = "org.eclipse.stp.bpmn.validation.BatchValidationBuildAbleNature";
    public static final String BUILDER_ID = "org.eclipse.stp.bpmn.validation.BatchValidationBuilder";

    public BpmnCreationWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("CreationWizardPage", workbench, selection);
        this.setTitle("Create Bpmn Diagram");
        this.setDescription("Create a new Bpmn diagram.");
    }

    public IFile createAndOpenDiagram(IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean saveDiagram) {
        this.setupBpmnValidationBuildableNature(containerPath);
        return BpmnDiagramEditorUtil.createAndOpenDiagram(this.getDiagramFileCreator(), containerPath, fileName, initialContents, kind, dWindow, progressMonitor, this.isOpenNewlyCreatedDiagramEditor(), saveDiagram);
    }

    protected String getNatureId() {
        return NATURE_ID;
    }

    protected String getBuilderId() {
        return BUILDER_ID;
    }

    protected void setupBpmnValidationBuildableNature(IPath containerPath) {
        String natureId = this.getNatureId();
        String builderId = this.getBuilderId();
        BpmnCreationWizardPage.setupBpmnValidationBuildableNature(containerPath, natureId, builderId);
    }

    public static final void setupBpmnValidationBuildableNature(IPath containerPath, String natureId, String builderId) {
        if (natureId == null && builderId == null) {
            return;
        }
        if (containerPath.segmentCount() < 1) {
            return;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
        if (res == null) {
            return;
        }
        IProject project = res.getProject();
        try {
            IProjectDescription description = project.getDescription();
            if (natureId != null) {
                String[] natures = description.getNatureIds();
                boolean foundTheNature = false;
                int i = 0;
                while (i < natures.length) {
                    if (NATURE_ID.equals(natures[i])) {
                        foundTheNature = true;
                        break;
                    }
                    ++i;
                }
                if (!foundTheNature) {
                    String[] newNatures = new String[natures.length + 1];
                    System.arraycopy(natures, 0, newNatures, 0, natures.length);
                    newNatures[natures.length] = NATURE_ID;
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                }
            }
            if (builderId != null) {
                ICommand[] commands = description.getBuildSpec();
                int i = 0;
                while (i < commands.length) {
                    if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                        return;
                    }
                    ++i;
                }
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 0, commands.length);
                ICommand command = description.newCommand();
                command.setBuilderName(BUILDER_ID);
                newCommands[newCommands.length - 1] = command;
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected String getDefaultFileName() {
        return "default";
    }

    public DiagramFileCreator getDiagramFileCreator() {
        return BpmnDiagramFileCreator.getInstance();
    }

    protected String getDiagramKind() {
        return BpmnDiagramEditPart.MODEL_ID;
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String fileName = this.getFileName();
            if (fileName == null) {
                return false;
            }
            IPath path = this.getContainerFullPath().append(this.getDiagramFileCreator().appendExtensionToFileName(fileName));
            path = path.removeFileExtension().addFileExtension("bpmn");
            if (ResourcesPlugin.getWorkspace().getRoot().exists(path)) {
                this.setErrorMessage("Model File already exists: " + path.lastSegment());
                return false;
            }
            return true;
        }
        return false;
    }
}

