/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.export;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramSVGGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class LazyCopyImageUtil
extends CopyToImageUtil {
    private ByteArrayOutputStream _stream = new ByteArrayOutputStream();

    protected void saveSVGToFile(IPath destination, DiagramSVGGenerator generator, IProgressMonitor monitor) throws CoreException {
        if (destination != null) {
            super.saveSVGToFile(destination, generator, monitor);
        } else if (this._stream != null) {
            generator.stream((OutputStream)this._stream);
        }
    }

    public ByteArrayOutputStream getStream() {
        return this._stream;
    }

    public void setStream(ByteArrayOutputStream stream) {
        this._stream = stream;
    }

    protected void saveToFile(IPath destination, Image image, ImageFileFormat imageFormat, IProgressMonitor monitor) throws CoreException {
        if (destination != null) {
            super.saveToFile(destination, image, imageFormat, monitor);
        } else {
            ImageData imageData = image.getImageData();
            if (imageFormat.equals((Object)ImageFileFormat.GIF)) {
                imageData = this.createImageData(image);
            }
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageData};
            imageLoader.logicalScreenHeight = image.getBounds().width;
            imageLoader.logicalScreenHeight = image.getBounds().height;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            imageLoader.save((OutputStream)stream, imageFormat.getOrdinal());
            this.setStream(stream);
        }
    }

    private ImageData createImageData(Image image) {
        ImageData imageData = image.getImageData();
        if (imageData.depth <= 8) {
            return imageData;
        }
        ImageData newImageData = this.get8BitPaletteImageData(imageData);
        if (newImageData == null) {
            newImageData = this.getWebSafePalletteImageData(imageData);
        }
        return newImageData;
    }

    private ImageData get8BitPaletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] colours = new RGB[256];
        PaletteData newPaletteData = new PaletteData(colours);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    newPixel = 0;
                    while (newPixel < 256) {
                        if (colours[newPixel] == null) {
                            colours[newPixel] = colour;
                            break;
                        }
                        if (colours[newPixel].equals((Object)colour)) break;
                        ++newPixel;
                    }
                    if (newPixel >= 256) {
                        return null;
                    }
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return newImageData;
    }

    private ImageData getWebSafePalletteImageData(ImageData imageData) {
        PaletteData palette = imageData.palette;
        RGB[] webSafePallette = this.getWebSafePallette();
        PaletteData newPaletteData = new PaletteData(webSafePallette);
        ImageData newImageData = new ImageData(imageData.width, imageData.height, 8, newPaletteData);
        int lastPixel = -1;
        int newPixel = -1;
        int i = 0;
        while (i < imageData.width) {
            int j = 0;
            while (j < imageData.height) {
                int pixel = imageData.getPixel(i, j);
                if (pixel != lastPixel) {
                    lastPixel = pixel;
                    RGB colour = palette.getRGB(pixel);
                    RGB webSafeColour = this.getWebSafeColour(colour);
                    newPixel = 0;
                    while (newPixel < 216) {
                        if (webSafePallette[newPixel].equals((Object)webSafeColour)) break;
                        ++newPixel;
                    }
                    Assert.isTrue((newPixel < 216 ? 1 : 0) != 0);
                }
                newImageData.setPixel(i, j, newPixel);
                ++j;
            }
            ++i;
        }
        return newImageData;
    }

    private RGB[] getWebSafePallette() {
        RGB[] colours = new RGB[256];
        int i = 0;
        int red = 0;
        while (red <= 255) {
            int green = 0;
            while (green <= 255) {
                int blue = 0;
                while (blue <= 255) {
                    RGB colour = new RGB(red, green, blue);
                    colours[i++] = colour;
                    blue += 51;
                }
                green += 51;
            }
            red += 51;
        }
        RGB colour = new RGB(0, 0, 0);
        int k = 0;
        while (k < 256) {
            if (colours[k] == null) {
                colours[k] = colour;
            }
            ++k;
        }
        return colours;
    }

    private RGB getWebSafeColour(RGB colour) {
        int red = Math.round((colour.red + 25) / 51) * 51;
        int green = Math.round((colour.green + 25) / 51) * 51;
        int blue = Math.round((colour.blue + 25) / 51) * 51;
        return new RGB(red, green, blue);
    }
}

