/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.EditModel;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;

public class ScribblerAdapter
extends AdapterImpl {
    private EditModel editModel = null;
    protected static String ADAPTER_TYPE = ScribblerAdapter.class.getName();
    private int readReferenceCount = 0;
    private int editReferenceCount = 0;
    protected boolean isNew = true;
    protected boolean forceRefresh;

    public static ScribblerAdapter findAdapter(Resource aResource) {
        return (ScribblerAdapter)EcoreUtil.getAdapter((List)aResource.eAdapters(), (Object)ADAPTER_TYPE);
    }

    protected ScribblerAdapter(EditModel anEditModel) {
        this.editModel = anEditModel;
    }

    public void notifyChanged(Notification msg) {
        if (msg.getFeatureID(null) == 0) {
            switch (msg.getEventType()) {
                case 4: 
                case 6: {
                    if (msg.getOldValue() != this.getTarget()) break;
                    EMFInfrastructurePlugin.log(1, 0, NLS.bind((String)Messages.Resource_0_has_been_del_, (Object)this.getTarget()), null);
                }
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == ADAPTER_TYPE;
    }

    public Resource getResource() {
        Notifier theTarget = this.getTarget();
        if (theTarget instanceof Resource) {
            return (Resource)theTarget;
        }
        return null;
    }

    public void accessForRead() throws EditModelException {
        try {
            this.checkDeleted();
            ++this.readReferenceCount;
        }
        finally {
            this.isNew = false;
        }
    }

    public void accessForWrite() throws EditModelException {
        try {
            this.checkDeleted();
            ++this.editReferenceCount;
            Resource resource = this.getResource();
            if (!resource.isTrackingModification()) {
                resource.setTrackingModification(true);
            }
        }
        finally {
            this.isNew = false;
        }
    }

    private void checkDeleted() throws EditModelException {
        Resource resource = this.getResource();
        if (resource.getResourceSet() == null) {
            throw new EditModelException(NLS.bind((String)Messages.Resource_0_has_been_del_, (Object)resource.getURI()));
        }
    }

    private int getTotalReferenceCount() {
        return this.editReferenceCount + this.readReferenceCount;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isReadOnly() {
        return this.editReferenceCount <= 0;
    }

    public boolean isShared() {
        return this.getTotalReferenceCount() > 1;
    }

    public boolean isSharedForWrite() {
        return this.editReferenceCount > 1;
    }

    public void releaseFromRead() throws EditModelException {
        --this.readReferenceCount;
        if (this.readReferenceCount < 0) {
            throw new EditModelException("Read reference count error:  " + this.toString());
        }
        this.unloadIfNecessary();
    }

    public void releaseFromWrite() throws EditModelException {
        --this.editReferenceCount;
        if (this.editReferenceCount < 0) {
            throw new EditModelException("Write reference count error:  " + (Object)((Object)this));
        }
        this.unloadIfNecessary();
    }

    public int getEditReferenceCount() {
        return this.editReferenceCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ScribblerAdapter[");
        buffer.append("ReadCnt=" + this.readReferenceCount + ",WriteCnt=" + this.editReferenceCount + ",IsNew=" + this.isNew + "]");
        return buffer.toString();
    }

    private void unloadIfNecessary() {
        if (!this.editModel.isDisposed() && !this.editModel.isReverting()) {
            Resource resource = this.getResource();
            if (this.getTotalReferenceCount() <= 0 || this.editReferenceCount <= 0 && resource.isModified()) {
                resource.unload();
                this.editModel.removeResource(resource);
            }
        }
    }
}

