/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.infrastructure.emf;

import java.util.HashSet;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.stp.core.infrastructure.emf.EditModelEvent;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IEditModelErrorHandler;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelListener;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.infrastructure.emf.EditModel;
import org.eclipse.stp.core.internal.infrastructure.emf.UnreleasedScribblerException;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchContext;
import org.eclipse.stp.core.tests.infrastructure.util.TestDomain;
import org.eclipse.stp.core.tests.infrastructure.util.TestEditModelListener;
import org.eclipse.stp.core.tests.infrastructure.util.TestErrorHandler;
import org.eclipse.stp.core.tests.infrastructure.util.TestProgressMonitor;
import org.eclipse.stp.core.tests.infrastructure.util.TestWorkspace;

public class IEditModelTest
extends TestCase {
    private static final String TEST_EDITMODEL_ID = "test.ejb.editmodel";

    public IEditModelTest(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(IEditModelTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestWorkspace.init();
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
        ProjectResourceSet resourceSet = context.getResourceSet();
        IEditModelTest.assertTrue((String)"Ensure there are zero resources loaded.", (resourceSet.getResources().size() == 0 ? 1 : 0) != 0);
        TestWorkspace.encourageGC();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TestWorkspace.encourageGC();
        TestDomain ejbDomain = TestDomain.createTestDomain(TestWorkspace.getTestProject());
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
        ProjectResourceSet resourceSet = context.getResourceSet();
        IEditModelTest.assertTrue((String)"Ensure there are zero resources loaded.", (resourceSet.getResources().size() == 0 ? 1 : 0) != 0);
        Resource r = resourceSet.getResource(ejbDomain.getTestURI(), true);
        if (r != null) {
            r.unload();
        }
        resourceSet.getResources().remove((Object)r);
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        IEditModelTest.assertTrue((String)"Ensure there are zero EditModelListeners.", (((EditModel)editModel).getListeners().size() == 0 ? 1 : 0) != 0);
    }

    public void testCreateScribbler_LIScribblerDomain_Boolean_V1() {
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        try {
            IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{TestDomain.createTestDomain(TestWorkspace.getTestProject())}, false);
            IEditModelTest.assertTrue((String)"Ensure the referece count increased.", (((EditModel)editModel).getReferenceCount() == 1 ? 1 : 0) != 0);
            scribbler.close((IProgressMonitor)new NullProgressMonitor());
            IEditModelTest.assertTrue((String)"Ensure the referece count decreased.", (((EditModel)editModel).getReferenceCount() == 0 ? 1 : 0) != 0);
        }
        catch (EditModelException e) {
            System.err.println("Could not create scribbler");
            e.printStackTrace();
        }
    }

    public void testCreateScribbler_LIScribblerDomain_Boolean_V2() {
        UnreleasedScribblerException.exceptions = new HashSet();
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        try {
            try {
                IEditModelTest.assertTrue((String)"Ensure the reference count increased.", (((EditModel)editModel).getReferenceCount() == 0 ? 1 : 0) != 0);
                IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{TestDomain.createTestDomain(TestWorkspace.getTestProject())}, false);
                IEditModelTest.assertTrue((String)"Ensure the scribbler is NOT created dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
                IEditModelTest.assertTrue((String)"Ensure the referece count increased.", (((EditModel)editModel).getReferenceCount() == 1 ? 1 : 0) != 0);
                scribbler = null;
                System.out.println("---------BEGIN EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
                TestWorkspace.encourageGC();
                EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
                ProjectResourceSet resourceSet = context.getResourceSet();
                Resource r = resourceSet.getResource(TestDomain.createTestDomain(TestWorkspace.getTestProject()).getTestURI(), true);
                if (r != null) {
                    r.unload();
                }
                resourceSet.getResources().remove((Object)r);
                IEditModelTest.assertTrue((String)"There should have been one unreleased scribbler exception thrown.", (UnreleasedScribblerException.exceptions.size() == 1 ? 1 : 0) != 0);
                System.out.println("---------END EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
            }
            catch (EditModelException e) {
                System.err.println("Could not create scribbler");
                e.printStackTrace();
                UnreleasedScribblerException.exceptions.clear();
            }
        }
        finally {
            UnreleasedScribblerException.exceptions.clear();
        }
    }

    public void testCreateScribbler_LIScribblerDomain_Boolean_V3() {
        UnreleasedScribblerException.exceptions = new HashSet();
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        try {
            try {
                TestDomain ejbDomain = TestDomain.createTestDomain(TestWorkspace.getTestProject());
                IEditModelTest.assertTrue((String)"Ensure there are zero EditModelListeners.", (((EditModel)editModel).getListeners().size() == 0 ? 1 : 0) != 0);
                int initialRefCount = ((EditModel)editModel).getReferenceCount();
                IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{ejbDomain}, false);
                IEditModelTest.assertTrue((String)"Ensure the scribbler is NOT created dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
                IEditModelTest.assertEquals((String)"Ensure the referece count increased by one.", (int)(initialRefCount + 1), (int)((EditModel)editModel).getReferenceCount());
                IEditModelTest.assertTrue((String)"Ensure there is exactly one EditModelListener (from the Scribbler).", (((EditModel)editModel).getListeners().size() == 1 ? 1 : 0) != 0);
                scribbler = null;
                System.out.println("---------BEGIN EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
                TestWorkspace.encourageGC();
                EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
                ProjectResourceSet resourceSet = context.getResourceSet();
                IEditModelTest.assertTrue((String)"Ensure there are zero resources loaded.", (resourceSet.getResources().size() == 0 ? 1 : 0) != 0);
                Resource resource = resourceSet.getResource(ejbDomain.getTestURI(), true);
                resource.unload();
                resourceSet.getResources().remove((Object)resource);
                IEditModelTest.assertTrue((String)"Ensure there are zero EditModelListeners.", (((EditModel)editModel).getListeners().size() == 0 ? 1 : 0) != 0);
                IEditModelTest.assertTrue((String)"There should have been one unreleased scribbler exception thrown.", (UnreleasedScribblerException.exceptions.size() == 1 ? 1 : 0) != 0);
                System.out.println("---------END EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
            }
            catch (EditModelException e) {
                System.err.println("Could not create scribbler");
                e.printStackTrace();
                UnreleasedScribblerException.exceptions.clear();
            }
        }
        finally {
            UnreleasedScribblerException.exceptions.clear();
        }
    }

    public void testCreateScribbler_LIScribblerDomain_Boolean_V4() {
        UnreleasedScribblerException.exceptions = new HashSet();
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        try {
            try {
                int initialRefCount = ((EditModel)editModel).getReferenceCount();
                IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{TestDomain.createTestDomain(TestWorkspace.getTestProject())}, false);
                IEditModelScribbler scribbler2 = editModel.createScribbler(new IScribblerDomain[]{TestDomain.createTestDomain(TestWorkspace.getTestProject())}, false);
                IEditModelTest.assertTrue((String)"Ensure the scribbler is NOT created dirty.", (!scribbler.isDirty() ? 1 : 0) != 0);
                IEditModelTest.assertTrue((String)"Ensure the scribbler is NOT created dirty.", (!scribbler2.isDirty() ? 1 : 0) != 0);
                IEditModelTest.assertEquals((String)"Ensure the referece count increased by two.", (int)(initialRefCount + 2), (int)((EditModel)editModel).getReferenceCount());
                System.out.println("---------BEGIN EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
                scribbler = null;
                scribbler2 = null;
                TestWorkspace.encourageGC();
                EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
                ProjectResourceSet resourceSet = context.getResourceSet();
                Resource r = resourceSet.getResource(TestDomain.createTestDomain(TestWorkspace.getTestProject()).getTestURI(), true);
                if (r != null) {
                    r.unload();
                }
                resourceSet.getResources().remove((Object)r);
                IEditModelTest.assertTrue((String)"There should have been one unreleased scribbler exception thrown.", (UnreleasedScribblerException.exceptions.size() == 2 ? 1 : 0) != 0);
                System.out.println("---------END EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
            }
            catch (EditModelException e) {
                System.err.println("Could not create scribbler");
                e.printStackTrace();
                UnreleasedScribblerException.exceptions.clear();
            }
        }
        finally {
            UnreleasedScribblerException.exceptions.clear();
        }
    }

    public void testNotifiactionOnLoad() throws Exception {
        TestDomain ejbDomain = TestDomain.createTestDomain(TestWorkspace.getTestProject());
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
        ProjectResourceSet resourceSet = context.getResourceSet();
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{ejbDomain}, false);
        IEditModelTest.assertTrue((String)"Ensure there are zero resources loaded.", (resourceSet.getResources().size() == 0 ? 1 : 0) != 0);
        TestEditModelListener testListener = new TestEditModelListener(6);
        editModel.addListener((IEditModelListener)testListener);
        Resource resource = resourceSet.getResource(ejbDomain.getTestURI(), true);
        editModel.removeListener((IEditModelListener)testListener);
        IEditModelTest.assertTrue((String)"A notification of the loaded resource should have been received.", (testListener.getEvents().length == 1 ? 1 : 0) != 0);
        EditModelEvent event = testListener.getEvents()[0];
        IEditModelTest.assertTrue((String)"A notification of the loaded resource should have been received.", (event.getEventCode() == 6 ? 1 : 0) != 0);
        IEditModelTest.assertTrue((String)"The resources in the changed list should match the above resource.", (event.getChangedResources().size() == 1 && event.getChangedResources().contains(resource) ? 1 : 0) != 0);
        scribbler.close(null);
        resource.unload();
        resourceSet.getResources().remove((Object)resource);
    }

    public void testNotifiactionOnSave() throws Exception {
        TestDomain ejbDomain = TestDomain.createTestDomain(TestWorkspace.getTestProject());
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{ejbDomain}, false);
        Resource resource = scribbler.getResource(ejbDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("TestDisplayName");
        IEditModelTest.assertTrue((String)"Ensure the resource is marked as modified.", (boolean)resource.isModified());
        TestProgressMonitor testMonitor = new TestProgressMonitor(3);
        TestEditModelListener testListener = new TestEditModelListener(1);
        editModel.addListener((IEditModelListener)testListener);
        scribbler.save(true, (IProgressMonitor)testMonitor);
        editModel.removeListener((IEditModelListener)testListener);
        IEditModelTest.assertTrue((String)"A notification should have been received.", (testListener.getEvents().length == 1 ? 1 : 0) != 0);
        EditModelEvent event = testListener.getEvents()[0];
        IEditModelTest.assertTrue((String)"A notification of the type 'save' should have been received.", (event.getEventCode() == 1 ? 1 : 0) != 0);
        IEditModelTest.assertTrue((String)"The resources in the changed list should match the above resource.", (event.getChangedResources().size() == 1 && event.getChangedResources().contains(resource) ? 1 : 0) != 0);
        scribbler.close(null);
    }

    public void testNotifiactionOnRevert() throws Exception {
        TestDomain ejbDomain = TestDomain.createTestDomain(TestWorkspace.getTestProject());
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{ejbDomain}, false);
        Resource resource = scribbler.getResource(ejbDomain.getTestURI());
        EJBJar jar = (EJBJar)resource.getContents().get(0);
        jar.setDisplayName("TestDisplayName");
        IEditModelTest.assertTrue((String)"Ensure the resource is marked as modified.", (boolean)resource.isModified());
        TestProgressMonitor testMonitor = new TestProgressMonitor(3);
        TestEditModelListener testListener = new TestEditModelListener(10);
        editModel.addListener((IEditModelListener)testListener);
        scribbler.revert((IProgressMonitor)testMonitor);
        editModel.removeListener((IEditModelListener)testListener);
        IEditModelTest.assertTrue((String)"A notification should have been received.", (testListener.getEvents().length == 1 ? 1 : 0) != 0);
        EditModelEvent event = testListener.getEvents()[0];
        IEditModelTest.assertTrue((String)"A notification of the type 'revert' should have been received.", (event.getEventCode() == 10 ? 1 : 0) != 0);
        IEditModelTest.assertTrue((String)"The resources in the changed list should match the above resource.", (event.getChangedResources().size() == 1 && event.getChangedResources().contains(resource) ? 1 : 0) != 0);
        scribbler.close(null);
    }

    public void testIsInterrestedInResourceResource() {
    }

    public void testGetOperationHistory() {
    }

    public void testSetErrorHandler() throws EditModelException {
        IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(TestWorkspace.getTestProject(), TEST_EDITMODEL_ID);
        TestDomain ejbDomain = TestDomain.createTestDomain(TestWorkspace.getTestProject());
        IEditModelScribbler scribbler = editModel.createScribbler(new IScribblerDomain[]{ejbDomain}, false);
        TestErrorHandler testErrorHandler = new TestErrorHandler();
        editModel.setErrorHandler((IEditModelErrorHandler)testErrorHandler);
        Resource resource = scribbler.getResource((IPath)new Path("nullpath"));
        IEditModelTest.assertNull((String)"The returned resource should be null.", (Object)resource);
        IEditModelTest.assertTrue((String)"Ensure that a load error occurred for the resource.", (boolean)testErrorHandler.handledLoadFailed);
        editModel.setErrorHandler(null);
        System.out.println("---------BEGIN EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
        resource = scribbler.getResource((IPath)new Path("nullpath1"));
        System.out.println("---------END EXPECTED ERROR LOG [" + ((Object)((Object)this)).getClass().getName() + "]--------------");
        scribbler.close(null);
        EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
        ProjectResourceSet resourceSet = context.getResourceSet();
        resourceSet.getResources().clear();
    }

    public void testDispose() throws Exception {
        IProject project = TestWorkspace.getTestProject();
        try {
            IEditModel editModel = IEditModelFactory.eINSTANCE.getEditModel(project, TEST_EDITMODEL_ID);
            TestEditModelListener testListener = new TestEditModelListener(5);
            editModel.addListener((IEditModelListener)testListener);
            project.close(null);
            IEditModelTest.assertTrue((String)"The edit model should be disposed.", (boolean)editModel.isDisposed());
            IEditModelTest.assertEquals((String)"The set of resources for the edit model should be empty.", (int)0, (int)((EditModel)editModel).getResources().size());
            IEditModelTest.assertEquals((String)"There should have been one event.", (int)1, (int)testListener.getEvents().length);
            EditModelEvent[] events = testListener.getEvents();
            IEditModelTest.assertEquals((String)"The event should have been of type pre_dispose", (int)5, (int)events[0].getEventCode());
            project.open(null);
            EMFWorkbenchContext context = EMFWorkbenchContext.getInstance((IProject)TestWorkspace.getTestProject());
            ProjectResourceSet resourceSet = context.getResourceSet();
            IEditModelTest.assertEquals((String)"The set of resources for the resource set should be empty.", (int)0, (int)resourceSet.getResources().size());
        }
        finally {
            if (!project.isAccessible()) {
                project.open(null);
            }
        }
    }
}

