/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EclipseResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.resources.SOACoreScribblerDomain;

public class SubsystemScribblerDomain
extends SOACoreScribblerDomain
implements IScribblerDomain {
    private static final String SUBSYSTEM_EXT = "subsystem";
    private final IFile subsystem;
    private final IResourceDescriptor[] descriptors;

    public SubsystemScribblerDomain(IFile aSubsystem) {
        super(aSubsystem.getProject());
        Assert.isTrue((boolean)SUBSYSTEM_EXT.equals(aSubsystem.getFileExtension()));
        this.subsystem = aSubsystem;
        this.descriptors = new IResourceDescriptor[]{new EclipseResourceDescriptor(this.subsystem)};
    }

    public IResourceDescriptor[] getResourceDescriptors() {
        return this.descriptors;
    }

    public IResourceDescriptor getSubsystemDescriptor() {
        return this.descriptors[0];
    }
}

