/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SWTUtils {
    public static Button getDialogButton(Dialog aDialog, String buttonLabel) {
        return SWTUtils.getButtonInComposite((Composite)aDialog.buttonBar, buttonLabel);
    }

    public static Button getButtonInComposite(Composite composite, String expectedText) {
        return (Button)SWTUtils.getControlInComposite(composite, Button.class.getName(), expectedText);
    }

    public static Label getLabelInComposite(Composite composite, String expectedText) {
        return (Label)SWTUtils.getControlInComposite(composite, Label.class.getName(), expectedText);
    }

    public static Text getTextInComposite(Composite composite, String expectedText) {
        return (Text)SWTUtils.getControlInComposite(composite, Text.class.getName(), expectedText);
    }

    public static Text getTextInCompositeByLabel(Composite composite, String expectedLabel) {
        int i = 0;
        while (i < composite.getChildren().length) {
            Control txt;
            Text ret;
            Control ctl = composite.getChildren()[i];
            if (ctl instanceof Composite && (ret = SWTUtils.getTextInCompositeByLabel((Composite)ctl, expectedLabel)) != null) {
                return ret;
            }
            if (ctl instanceof Label && ((Label)ctl).getText().equals(expectedLabel) && composite.getChildren().length != i + 1 && (txt = composite.getChildren()[i + 1]) instanceof Text) {
                return (Text)txt;
            }
            ++i;
        }
        return null;
    }

    public static Control getControlInComposite(Composite composite, String className, String expectedText) {
        Control control = null;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            control = child instanceof Composite ? SWTUtils.getControlInComposite((Composite)child, className, expectedText) : SWTUtils.getMatchingTextControl(child, expectedText);
            if (control != null && control.getClass().getName().equals(className)) {
                return control;
            }
            ++i;
        }
        return null;
    }

    private static Control getMatchingTextControl(Control control, String expectedText) {
        String controlText = SWTUtils.getControlText(control);
        if (SWTUtils.isMatchingText(controlText, expectedText)) {
            return control;
        }
        return null;
    }

    public static String getControlText(Control control) {
        if (control instanceof Label) {
            return ((Label)control).getText();
        }
        if (control instanceof Button) {
            return ((Button)control).getText();
        }
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        return null;
    }

    private static boolean isMatchingText(String currentText, String expectedText) {
        return currentText != null && currentText.indexOf(expectedText) != -1;
    }
}

