/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.generators.types;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.generators.types.JaxBindTypeGenerator;
import org.eclipse.stp.sc.jaxws.tests.ScProjectBaseTest;

public class JaxBindTypeGeneratorComplexTypeTest
extends ScProjectBaseTest {
    public static final String PROJECT_NAME = "JaxBindTypeGeneratorTestProject";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxBindTypeGeneratorComplexTypeTest.class);
    protected String[] projectFiles = new String[]{"/src/complextest/TypeTest.java"};
    protected String[] resourceFiles = new String[]{"/resources/TypeTest.java_resource"};

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    protected void setUp() throws Exception {
        super.setUp();
        WorkspaceManager.setWorkspaceAutoBuild((boolean)false);
        ICompilationUnit compUnit = JDTUtils.getJavaUnitFromFile((IFile)this.files[0]);
        JaxBindTypeGenerator generator = new JaxBindTypeGenerator();
        generator.createWrapperCls(compUnit);
        this.project.refreshLocal(0, null);
    }

    protected void tearDown() throws Exception {
        WorkspaceManager.setWorkspaceAutoBuild((boolean)true);
    }

    public void testStringArray() throws Exception {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("complextest");
        IFile reqFile = folder.getFile("StringArrayFunc.java");
        IFile respFile = folder.getFile("StringArrayFuncResponse.java");
        JaxBindTypeGeneratorComplexTypeTest.assertTrue((String)"should generate StringArrayFunc.java", (boolean)reqFile.exists());
        JaxBindTypeGeneratorComplexTypeTest.assertTrue((String)"should generate StringArrayFuncResponse.java", (boolean)respFile.exists());
        ICompilationUnit strArrayUnit = JDTUtils.getJavaUnitFromFile((IFile)reqFile);
        IMethod[] iMethodArray = strArrayUnit.findPrimaryType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            System.err.println("name:" + method.getElementName());
            System.err.println("sig:" + method.getSignature());
            ++n2;
        }
        JaxBindTypeGeneratorComplexTypeTest.assertNotNull((String)"should has getTest method", (Object)strArrayUnit.findPrimaryType().getMethod("getTest", new String[0]));
        JaxBindTypeGeneratorComplexTypeTest.assertNotNull((String)"should has setTest method", (Object)strArrayUnit.findPrimaryType().getMethod("setTest", new String[]{"QString;"}));
    }

    public void testArrayList() throws Exception {
        IFolder folder = this.project.getFolder("src");
        folder = folder.getFolder("complextest");
        IFile reqFile = folder.getFile("ArrayListFunc.java");
        IFile respFile = folder.getFile("ArrayListFuncResponse.java");
        JaxBindTypeGeneratorComplexTypeTest.assertTrue((String)"should generate ArrayListFunc.java", (boolean)reqFile.exists());
        JaxBindTypeGeneratorComplexTypeTest.assertTrue((String)"should generate ArrayListFuncResponse.java", (boolean)respFile.exists());
        ICompilationUnit strArrayUnit = JDTUtils.getJavaUnitFromFile((IFile)reqFile);
        IMethod[] iMethodArray = strArrayUnit.findPrimaryType().getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            System.err.println("name:" + method.getElementName());
            System.err.println("sig:" + method.getSignature());
            ++n2;
        }
    }
}

