/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractStartingPointPageContents
implements IStartingPointPageContents {
    protected Text txtStartingPoint;
    protected List lstDependentJavaFiles;
    protected List lstDependentLibFiles;
    protected Shell shell;
    protected Button btnBrowse;
    protected Button btnAdd1;
    protected Button btnAdd2;
    protected Button btnRemove1;
    protected Button btnRemove2;
    protected TabFolder tabFolder;
    protected SelectionListener selectionListener;
    protected boolean isPageValid = false;
    protected String errMsg = null;
    protected IPageContentsChangeListener listener = null;
    protected IProject project;

    public String[] getDependentJavaFiles() {
        return this.lstDependentJavaFiles.getItems();
    }

    public String[] getDependentLibraries() {
        return this.lstDependentLibFiles.getItems();
    }

    public String getStartingPoint() {
        return this.txtStartingPoint.getText();
    }

    public String validateStartingPoint(String startingPoint) {
        String returnValue = null;
        if (startingPoint != null && startingPoint.trim().length() > 0) {
            if (startingPoint.trim().toLowerCase().endsWith(".java")) {
                File file = new File(startingPoint.trim());
                if (!file.exists()) {
                    returnValue = ScJaxWsResources.getString("error.JavaFileNotExist");
                }
            } else {
                returnValue = ScJaxWsResources.getString("error.InvalidJavaFile");
            }
        } else {
            returnValue = ScJaxWsResources.getString("error.EmptyJavaFile");
        }
        return returnValue;
    }

    public Control createContents(Composite parent) {
        this.shell = parent.getShell();
        GridData gridData = new GridData(1808);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group grpStartingPoint = new Group(composite, 0);
        grpStartingPoint.setLayoutData((Object)new GridData(768));
        grpStartingPoint.setLayout((Layout)new GridLayout(3, false));
        new Label((Composite)grpStartingPoint, 0).setText("Java Source File");
        this.txtStartingPoint = new Text((Composite)grpStartingPoint, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.txtStartingPoint.setLayoutData((Object)gridData);
        this.txtStartingPoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractStartingPointPageContents.this.validatePageContents();
            }
        });
        this.btnBrowse = new Button((Composite)grpStartingPoint, 8);
        this.btnBrowse.setText("Browse...");
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FileDialog dialog = new FileDialog(AbstractStartingPointPageContents.this.shell);
                dialog.setFilterExtensions(new String[]{"*.java"});
                dialog.setFilterPath(AbstractStartingPointPageContents.this.txtStartingPoint.getText());
                String selectedFile = dialog.open();
                if (selectedFile != null) {
                    AbstractStartingPointPageContents.this.txtStartingPoint.setText(selectedFile);
                }
            }
        };
        this.btnBrowse.addSelectionListener(this.selectionListener);
        Group grpDependencies = new Group(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        grpDependencies.setLayout((Layout)new GridLayout(1, false));
        grpDependencies.setLayoutData((Object)gridData);
        grpDependencies.setText("Dependencies");
        this.tabFolder = new TabFolder((Composite)grpDependencies, 128);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        this.tabFolder.setLayoutData((Object)gridData);
        TabItem tabItemJavaFiles = new TabItem(this.tabFolder, 0);
        tabItemJavaFiles.setText("Java Files");
        TabItem tabItemLibFiles = new TabItem(this.tabFolder, 0);
        tabItemLibFiles.setText("Libraries");
        Composite comJavaFiles = new Composite((Composite)this.tabFolder, 0);
        tabItemJavaFiles.setControl((Control)comJavaFiles);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        comJavaFiles.setLayout((Layout)new GridLayout(2, false));
        comJavaFiles.setLayoutData((Object)gridData);
        this.lstDependentJavaFiles = new List(comJavaFiles, 2818);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        this.lstDependentJavaFiles.setLayoutData((Object)gridData);
        this.btnAdd1 = new Button(comJavaFiles, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAdd1.setLayoutData((Object)gridData);
        this.btnAdd1.setText("Add File(s)");
        this.btnAdd1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String[] files;
                FileDialog dialog = new FileDialog(AbstractStartingPointPageContents.this.shell, 2);
                dialog.setFilterExtensions(new String[]{"*.java"});
                dialog.setFilterPath(AbstractStartingPointPageContents.this.txtStartingPoint.getText());
                String selectedFile = dialog.open();
                if (selectedFile != null && (files = dialog.getFileNames()) != null && files.length > 0) {
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        AbstractStartingPointPageContents.this.lstDependentJavaFiles.add(String.valueOf(dialog.getFilterPath()) + File.separator + fileName);
                        ++n2;
                    }
                }
            }
        });
        this.btnRemove1 = new Button(comJavaFiles, 8);
        this.btnRemove1.setText("Remove");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnRemove1.setLayoutData((Object)gridData);
        this.btnRemove1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                AbstractStartingPointPageContents.this.lstDependentJavaFiles.remove(AbstractStartingPointPageContents.this.lstDependentJavaFiles.getSelectionIndices());
            }
        });
        Composite comLibFiles = new Composite((Composite)this.tabFolder, 0);
        tabItemLibFiles.setControl((Control)comLibFiles);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        comLibFiles.setLayout((Layout)new GridLayout(2, false));
        comLibFiles.setLayoutData((Object)gridData);
        this.lstDependentLibFiles = new List(comLibFiles, 2818);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        this.lstDependentLibFiles.setLayoutData((Object)gridData);
        this.btnAdd2 = new Button(comLibFiles, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAdd2.setLayoutData((Object)gridData);
        this.btnAdd2.setText("Add Jar(s)");
        this.btnAdd2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String[] files;
                FileDialog dialog = new FileDialog(AbstractStartingPointPageContents.this.shell, 2);
                dialog.setFilterExtensions(new String[]{"*.jar"});
                dialog.setFilterPath(AbstractStartingPointPageContents.this.txtStartingPoint.getText());
                String selectedFile = dialog.open();
                if (selectedFile != null && (files = dialog.getFileNames()) != null && files.length > 0) {
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        AbstractStartingPointPageContents.this.lstDependentLibFiles.add(String.valueOf(dialog.getFilterPath()) + File.separator + fileName);
                        ++n2;
                    }
                }
            }
        });
        this.btnRemove2 = new Button(comLibFiles, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnRemove2.setText("Remove");
        this.btnRemove2.setLayoutData((Object)gridData);
        this.btnRemove2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                AbstractStartingPointPageContents.this.lstDependentLibFiles.remove(AbstractStartingPointPageContents.this.lstDependentLibFiles.getSelectionIndices());
            }
        });
        return composite;
    }

    public String getDescription() {
        return null;
    }

    public String getErrorMsg() {
        return this.errMsg;
    }

    public String getPageName() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public boolean isPageValid() {
        return this.isPageValid;
    }

    public void performFinish() {
    }

    public void setChangeListener(IPageContentsChangeListener listener) {
        this.listener = listener;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private void validatePageContents() {
        this.errMsg = this.validateStartingPoint(this.txtStartingPoint.getText());
        this.isPageValid = this.errMsg == null;
        if (this.listener != null) {
            this.listener.whenValidStatusChanged();
        }
    }

    public boolean getNeedAddWebMethodAnnotations() {
        return true;
    }
}

