/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.sca.scdl;

import java.io.File;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.eclipse.stp.sc.sca.scdl.ScdlBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScdlBuilderTest
extends TestCase {
    File testFile;
    ScdlBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        this.builder = new ScdlBuilder();
        this.testFile = File.createTempFile("default", ".composite");
        this.testFile.deleteOnExit();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.builder = null;
    }

    public void testCreateRMIScdlFile() throws Exception {
        this.builder.setFileFullPath(this.testFile.getAbsolutePath());
        this.builder.setCompositeName("HelloWorldRmiComposite");
        this.builder.setCompName("HelloWorldServiceComponent");
        this.builder.setCompLan(ScdlBuilder.Language.JAVA);
        this.builder.setCompClass("helloworld.HelloWorldImpl");
        this.builder.setServiceName("HelloWorldRmiService");
        this.builder.setInterfaceName("helloworld.HelloWorldService");
        this.builder.setInterfaceType(ScdlBuilder.InfType.JAVA);
        this.builder.setBindingType(ScdlBuilder.BindingType.RMI);
        Hashtable<String, String> attrs = new Hashtable<String, String>();
        attrs.put("host", "localhost");
        attrs.put("port", "1099");
        attrs.put("serviceName", "HelloWorldRemoteService");
        this.builder.setBindingAttrs(attrs);
        boolean ret = this.builder.createScdlFile();
        ScdlBuilderTest.assertTrue((String)"build scdl should return true", (boolean)ret);
        ScdlBuilderTest.assertTrue((String)"should generate default.composite", (boolean)this.testFile.exists());
        ScdlBuilderTest.assertTrue((this.testFile.length() > 0L ? 1 : 0) != 0);
    }

    public void testTuscanyNSPrefix() throws Exception {
        this.builder.setFileFullPath(this.testFile.getAbsolutePath());
        this.builder.setCompositeName("HelloWorldRmiComposite");
        this.builder.setCompName("HelloWorldServiceComponent");
        this.builder.setCompLan(ScdlBuilder.Language.JAVA);
        this.builder.setCompClass("helloworld.HelloWorldImpl");
        this.builder.setServiceName("HelloWorldRmiService");
        this.builder.setInterfaceName("helloworld.HelloWorldService");
        this.builder.setInterfaceType(ScdlBuilder.InfType.JAVA);
        this.builder.setBindingType(ScdlBuilder.BindingType.RMI);
        Hashtable<String, String> attrs = new Hashtable<String, String>();
        attrs.put("host", "localhost");
        attrs.put("port", "1099");
        attrs.put("serviceName", "HelloWorldRemoteService");
        this.builder.setBindingAttrs(attrs);
        boolean ret = this.builder.createScdlFile();
        ScdlBuilderTest.assertTrue((String)"build scdl should return true", (boolean)ret);
        ScdlBuilderTest.assertTrue((String)"should generate default.composite", (boolean)this.testFile.exists());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(this.testFile.getAbsolutePath());
        doc.normalize();
        Element elem = (Element)doc.getElementsByTagName("composite").item(0);
        String tuscanyNS = elem.getAttribute("xmlns:tuscany");
        ScdlBuilderTest.assertEquals((String)tuscanyNS, (String)"http://tuscany.apache.org/xmlns/sca/1.0");
        Element comp = (Element)elem.getElementsByTagName("component").item(0);
        Element service = (Element)comp.getElementsByTagName("service").item(0);
        Element bindElem = (Element)service.getElementsByTagName("tuscany:binding.rmi").item(0);
        ScdlBuilderTest.assertNotNull((Object)bindElem);
    }

    public void testCreateWSScdlFile() throws Exception {
        this.builder.setFileFullPath(this.testFile.getAbsolutePath());
        this.builder.setCompositeName("helloworldws");
        this.builder.setCompName("HelloWorldServiceComponent");
        this.builder.setCompLan(ScdlBuilder.Language.JAVA);
        this.builder.setCompClass("helloworld.HelloWorldImpl");
        this.builder.setServiceName("HelloWorldWebService");
        this.builder.setInterfaceName("HelloWorldPortType");
        this.builder.setInterfaceType(ScdlBuilder.InfType.WSDL);
        this.builder.url = "http://helloworld";
        this.builder.setBindingType(ScdlBuilder.BindingType.WS);
        Hashtable<String, String> attrs = new Hashtable<String, String>();
        attrs.put("endpoint", "http://helloworld#wsdl.endpoint(HelloWorldService/HelloWorldSoapPort)");
        attrs.put("location", "wsdl/helloworld.wsdl");
        this.builder.setBindingAttrs(attrs);
        boolean ret = this.builder.createScdlFile();
        ScdlBuilderTest.assertTrue((String)"build scdl should return true", (boolean)ret);
        ScdlBuilderTest.assertTrue((String)"should generate default.composite", (boolean)this.testFile.exists());
        ScdlBuilderTest.assertTrue((this.testFile.length() > 0L ? 1 : 0) != 0);
    }
}

