/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.xmlvalidator.rule.engine;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleManager;

public abstract class VRuleEngineTestBase
extends TestCase {
    private static String PATH1_NAME = "rulepath1";
    private static String PATH2_NAME = "rulepath2";
    private static String PATH1_RULEFILE_PATH = "/" + PATH1_NAME + "/rule1.xml";
    private static String PATH2_RULEFILE_PATH = "/" + PATH2_NAME + "/rule2.xml";
    private static String RULEFILE1_PATH = "/resources/JAX_WS_VRules.xml";
    private static String RULEFILE2_PATH = "/resources/SCA_VRules.xml";
    protected IProject project;
    IFolder pathFolder1;
    IFolder pathFolder2;

    protected void setUp() throws Exception {
        super.setUp();
        this.project = WorkbenchUtils.createTestCeltixProject((String)this.getProjectName());
        WorkbenchUtils.setupBasicJavaProject((IProject)this.project);
        this.pathFolder1 = this.project.getFolder(PATH1_NAME);
        if (!this.pathFolder1.exists()) {
            this.pathFolder1.create(true, false, null);
        }
        this.pathFolder2 = this.project.getFolder(PATH2_NAME);
        if (!this.pathFolder2.exists()) {
            this.pathFolder2.create(true, false, null);
        }
        String seperator = System.getProperty("os.name").contains("Windows") ? ";" : ":";
        String rulePath = String.valueOf(this.pathFolder1.getLocation().toOSString()) + seperator + this.pathFolder2.getLocation().toOSString();
        System.setProperty(VRuleManager.DEFAULT_RULE_PATH_PROPERTY, rulePath);
        WorkbenchUtils.addFileResourceToTestProject((IProject)this.project, (String)PATH1_RULEFILE_PATH, ((Object)((Object)this)).getClass(), (String)RULEFILE1_PATH);
        WorkbenchUtils.addFileResourceToTestProject((IProject)this.project, (String)PATH2_RULEFILE_PATH, ((Object)((Object)this)).getClass(), (String)RULEFILE2_PATH);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.delete(true, null);
    }

    protected abstract String getProjectName();
}

