/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConfigurationManager;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class DeploymentDefinitionBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = String.valueOf(DeployCorePlugin.getDefault().getBundle().getSymbolicName()) + ".deploymentDefinitionBuilder";
    public static final String MARKER_TYPE = String.valueOf(DeployCorePlugin.getDefault().getBundle().getSymbolicName()) + ".deploymentDefinitionProblemMarker";
    public static final String MARKER_ATTR_PROBLEM_ELEMENT_URL = "problemElementURL";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.buildAll();
        } else {
            this.build(this.getDelta(this.getProject()));
        }
        return new IProject[0];
    }

    protected boolean isInteresting(IResource resource) {
        int resType = resource.getType();
        return resType == 2 || resType == 4 || resType == 8 || resType == 1 && "deploy".equals(resource.getFileExtension());
    }

    private void buildAll() throws CoreException {
        this.buildContainer((IContainer)this.getProject());
    }

    private void buildContainer(IContainer container) throws CoreException {
        IResource[] children = container.members();
        int index = 0;
        int count = children.length;
        while (index < count) {
            if (children[index].getType() == 1) {
                if (this.isInteresting(children[index])) {
                    this.fileChanged((IFile)children[index]);
                }
            } else {
                this.buildContainer((IContainer)children[index]);
            }
            ++index;
        }
    }

    private void build(IResourceDelta resDelta) throws CoreException {
        if (resDelta != null && this.isInteresting(resDelta.getResource())) {
            switch (resDelta.getKind()) {
                case 1: 
                case 4: {
                    this.resourceChanged(resDelta);
                    break;
                }
                case 2: {
                    this.resourceRemoved(resDelta);
                    break;
                }
            }
        }
    }

    private void resourceChanged(IResourceDelta resDelta) throws CoreException {
        switch (resDelta.getResource().getType()) {
            case 1: {
                this.fileChanged((IFile)resDelta.getResource());
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                IResourceDelta[] children = resDelta.getAffectedChildren();
                int index = 0;
                int count = children.length;
                while (index < count) {
                    this.build(children[index]);
                    ++index;
                }
                break;
            }
        }
    }

    private void resourceRemoved(IResourceDelta resDelta) throws CoreException {
        switch (resDelta.getResource().getType()) {
            case 1: {
                this.fileRemoved((IFile)resDelta.getResource());
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                IResourceDelta[] children = resDelta.getAffectedChildren();
                int index = 0;
                int count = children.length;
                while (index < count) {
                    this.build(children[index]);
                    ++index;
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void fileChanged(IFile file) throws CoreException {
        block11: {
            block10: {
                block12: {
                    rs = null;
                    try {
                        try {
                            file.deleteMarkers(DeploymentDefinitionBuilder.MARKER_TYPE, true, 0);
                            rs = new ResourceSetWithOptions();
                            resource = rs.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString()), true);
                            for (Resource.Diagnostic diag : resource.getErrors()) {
                                marker = file.createMarker(DeploymentDefinitionBuilder.MARKER_TYPE);
                                marker.setAttribute("severity", 2);
                                marker.setAttribute("location", (Object)file.getFullPath().toString());
                                marker.setAttribute("lineNumber", diag.getLine());
                                marker.setAttribute("problemElementURL", (Object)diag.getLocation());
                                marker.setAttribute("message", (Object)diag.getMessage());
                            }
                            for (Resource.Diagnostic diag : resource.getWarnings()) {
                                marker = file.createMarker(DeploymentDefinitionBuilder.MARKER_TYPE);
                                marker.setAttribute("severity", 1);
                                marker.setAttribute("location", (Object)file.getFullPath().toString());
                                marker.setAttribute("lineNumber", diag.getLine());
                                marker.setAttribute("problemElementURL", (Object)diag.getLocation());
                                marker.setAttribute("message", (Object)diag.getMessage());
                            }
                            this.validateDefinition(file, resource);
                            break block10;
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                            marker = file.createMarker(DeploymentDefinitionBuilder.MARKER_TYPE);
                            marker.setAttribute("severity", 2);
                            marker.setAttribute("location", (Object)file.getFullPath().toString());
                            marker.setAttribute("message", (Object)e.getMessage());
                            if (rs == null) break block11;
                            ** for (res : rs.getResources())
                        }
                    }
                    catch (Throwable var7_15) {
                        if (rs == null) break block12;
                        ** for (res : rs.getResources())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (!res.isLoaded()) continue;
                        res.unload();
                        continue;
                    }
lbl36:
                    // 1 sources

                    rs.getResources().clear();
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        if (!res.isLoaded()) continue;
                        res.unload();
                        continue;
                    }
lbl44:
                    // 1 sources

                    rs.getResources().clear();
                }
                throw var7_15;
            }
            if (rs != null) {
                for (Resource res : rs.getResources()) {
                    if (!res.isLoaded()) continue;
                    res.unload();
                }
                rs.getResources().clear();
            }
        }
    }

    private void fileRemoved(IFile file) throws CoreException {
    }

    protected void validateDefinition(IFile file, Resource resource) throws CoreException {
        if (resource.getContents().size() == 0 || !(resource.getContents().get(0) instanceof Root)) {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.InvalidDefinitionError"));
            return;
        }
        Root root = (Root)resource.getContents().get(0);
        Iterator it = root.getServer().iterator();
        while (it.hasNext()) {
            this.validateServer(file, (DeployServer)it.next());
        }
        it = root.getPackage().iterator();
        while (it.hasNext()) {
            this.validatePackage(file, (DeployPackage)it.next());
        }
    }

    protected void validateServer(IFile file, DeployServer server) throws CoreException {
        IMarker marker;
        if (ServerCore.findServer((String)server.getServerId()) == null) {
            marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.InvalidServerError", new Object[]{server.getProfileName()}));
            marker.setAttribute(MARKER_ATTR_PROBLEM_ELEMENT_URL, (Object)server.eResource().getURIFragment((EObject)server));
        }
        if (server.getTargetingConfiguration().size() == 0) {
            marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("severity", 1);
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.UnusedServerWarning", new Object[]{server.getProfileName()}));
            marker.setAttribute(MARKER_ATTR_PROBLEM_ELEMENT_URL, (Object)server.eResource().getURIFragment((EObject)server));
        }
    }

    protected void validatePackage(IFile file, DeployPackage pkg) throws CoreException {
        if (pkg.getTargetConfiguration().size() == 0) {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.UntargetedPackageError", new Object[]{pkg.getPackageFile()}));
            marker.setAttribute(MARKER_ATTR_PROBLEM_ELEMENT_URL, (Object)pkg.eResource().getURIFragment((EObject)pkg));
            return;
        }
        Iterator it = pkg.getTargetConfiguration().iterator();
        while (it.hasNext()) {
            this.validateConfiguration(file, (DeployConfiguration)it.next());
        }
    }

    protected void validateConfiguration(IFile file, DeployConfiguration configuration) throws CoreException {
        IPackage ip;
        if (configuration.getTargetServer() == null) {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.UspecifiedTargetServerError", new Object[]{configuration.getSourcePackage().getPackageFile()}));
            marker.setAttribute(MARKER_ATTR_PROBLEM_ELEMENT_URL, (Object)configuration.eResource().getURIFragment((EObject)configuration));
        }
        if ((ip = Utilities.adaptToIPackage((EObject)configuration)) == null) {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("location", (Object)file.getFullPath().toString());
            marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.CouldNotAdaptPackageError", new Object[]{configuration.getSourcePackage().getPackageFile(), configuration.getTargetServer().getProfileName()}));
            marker.setAttribute(MARKER_ATTR_PROBLEM_ELEMENT_URL, (Object)configuration.eResource().getURIFragment((EObject)configuration));
            return;
        }
        if (ip instanceof IServiceDescriptor) {
            IPackageConstructorExtension ipce;
            IServiceDescriptor ilp = (IServiceDescriptor)ip;
            IPackageConfiguration packageConfig = null;
            if (ip instanceof IConfigurablePackage) {
                IPackageConfigurationManager packageConfigManager = ((IConfigurablePackageExtension)ilp.getExtension()).getPackageConfigurationManager();
                byte[] configOverride = configuration.getConfigOverride();
                if (configOverride != null && configOverride.length != 0) {
                    try {
                        packageConfig = packageConfigManager.createPackageConfiguration((IConfigurablePackage)ilp, new ByteArrayInputStream(configOverride));
                    }
                    catch (Exception e) {
                        IMarker marker = file.createMarker(MARKER_TYPE);
                        marker.setAttribute("severity", 2);
                        marker.setAttribute("location", (Object)file.getFullPath().toString());
                        marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.ConfigOverrideParseError", new Object[]{configuration.getSourcePackage().getPackageFile(), configuration.getTargetServer().getProfileName(), e.getLocalizedMessage()}));
                        marker.setAttribute(MARKER_ATTR_PROBLEM_ELEMENT_URL, (Object)configuration.eResource().getURIFragment((EObject)configuration));
                        return;
                    }
                }
            }
            IStatus[] validationStatus = (ipce = this.getPackageConstructor(ilp, configuration)) == null ? new IStatus[]{} : ipce.validatePackage(ilp, packageConfig, null);
            for (IStatus status : Arrays.asList(validationStatus)) {
                IMarker marker = file.createMarker(MARKER_TYPE);
                marker.setAttribute("severity", this.convertStatusSeverityToMarkerSeverity(status.getSeverity()));
                marker.setAttribute("location", (Object)file.getFullPath().toString());
                marker.setAttribute("message", (Object)DeployCorePlugin.getDefault().getResourceString("Builder.PackageConfigurationError", new Object[]{configuration.getSourcePackage().getPackageFile(), configuration.getTargetServer().getProfileName(), status.getMessage()}));
                marker.setAttribute(MARKER_ATTR_PROBLEM_ELEMENT_URL, (Object)configuration.eResource().getURIFragment((EObject)configuration));
            }
        }
    }

    private int convertStatusSeverityToMarkerSeverity(int statusSeverity) {
        int markerSeverity;
        switch (statusSeverity) {
            case 4: {
                markerSeverity = 2;
                break;
            }
            case 2: {
                markerSeverity = 1;
                break;
            }
            default: {
                markerSeverity = 0;
            }
        }
        return markerSeverity;
    }

    private IPackageConstructorExtension getPackageConstructor(IServiceDescriptor pkg, DeployConfiguration deployConfig) {
        IServer server = ServerCore.findServer((String)deployConfig.getTargetServer().getServerId());
        IServerType ist = DeploymentUtil.convertWTPServerTypeToSTPServerType(server.getServerType());
        return DeploymentExtensionManager.getInstance().getPackageConstructor(pkg, ist);
    }

    private static class ResourceSetWithOptions
    extends ResourceSetImpl {
        public ResourceSetWithOptions() {
            this.loadOptions = new HashMap();
            this.loadOptions.put("PROCESS_DANGLING_HREF", "RECORD");
        }
    }
}

