/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.xml.internal.w3c;

import java.io.IOException;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NamedNodeMap;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;

public class DocumentWriter {
    String file;
    boolean ignoreComments = false;

    public DocumentWriter(String file) {
        this.file = file;
    }

    public void setIgnoreComments(boolean b) {
        this.ignoreComments = b;
    }

    public String writeDoc(Node root, boolean human_readable) throws IOException {
        return this.writeDoc(root, human_readable, false);
    }

    public String writeNode(Node root, boolean human_readable) throws IOException {
        return this.writeNode(root, human_readable, false);
    }

    public String writeDoc(Node root, boolean human_readable, boolean track_lines) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(root, sb, 0, human_readable, track_lines ? new LineTracker(sb) : null);
        return sb.toString();
    }

    public String writeNode(Node root, boolean human_readable, boolean track_lines) throws IOException {
        StringBuffer sb = new StringBuffer();
        this.write(root, sb, 0, human_readable, track_lines ? new LineTracker(sb) : null);
        return sb.toString();
    }

    private void write(Node node, StringBuffer sb, int depth, boolean human_readable, LineTracker lt) throws IOException {
        block41: {
            Node child;
            NodeList list;
            int i;
            block39: {
                block40: {
                    if (lt != null) {
                        node.setWrittenLine(lt.getLines());
                    }
                    String nodename = node.getNodeName();
                    String nodevalue = node.getNodeValue();
                    if (node.getNodeType() == Node.TEXT_NODE) {
                        char[] tmp = nodevalue.toCharArray();
                        i = 0;
                        while (i < tmp.length) {
                            if (tmp[i] == '<') {
                                sb.append("&lt;");
                            } else {
                                sb.append(tmp[i]);
                            }
                            ++i;
                        }
                    } else if (node.getNodeType() == Node.COMMENT_NODE) {
                        if (!this.ignoreComments) {
                            sb.append("<!--").append(nodevalue).append("-->");
                        }
                    } else if (node.getNodeType() == Node.ELEMENT_NODE) {
                        if (human_readable) {
                            int i2 = 0;
                            while (i2 < depth) {
                                sb.append("  ");
                                ++i2;
                            }
                        }
                        sb.append('<');
                        sb.append(nodename);
                        NamedNodeMap map = node.getAttributes();
                        i = 0;
                        while (i < map.getLength()) {
                            Node attr = map.item(i);
                            String name = attr.getNodeName();
                            String value = attr.getNodeValue();
                            if (value != null) {
                                if (human_readable && i > 0) {
                                    sb.append('\n');
                                    int tmp = depth * 2 + nodename.length() + 1;
                                    int k = 0;
                                    while (k < tmp) {
                                        sb.append(' ');
                                        ++k;
                                    }
                                }
                                sb.append(" ");
                                sb.append(name);
                                sb.append("=\"");
                                int strlen = value.length();
                                char ch = '\u0000';
                                int c = 0;
                                while (c < strlen) {
                                    ch = value.charAt(c);
                                    if (ch == '&') {
                                        sb.append("&amp");
                                    } else if (ch == '<') {
                                        sb.append("&lt;");
                                    } else if (ch == '>') {
                                        sb.append("&gt;");
                                    } else if (ch == '\"') {
                                        sb.append("&qt;");
                                    } else if (ch == '\'') {
                                        sb.append("&apos;");
                                    } else {
                                        sb.append(ch);
                                    }
                                    ++c;
                                }
                                sb.append("\"");
                            }
                            ++i;
                        }
                    }
                    list = node.getChildNodes();
                    if (node.getNodeType() != Node.ELEMENT_NODE) break block39;
                    if (list.getLength() != 0 || lt != null) break block40;
                    sb.append(" />");
                    if (human_readable) {
                        sb.append('\n');
                    }
                    break block41;
                }
                sb.append(" >");
                if (lt != null) {
                    Node n;
                    boolean hasLineNumber = false;
                    if (list.getLength() > 0 && (n = list.item(0)).getNodeType() == Node.COMMENT_NODE && n.getNodeValue().trim().startsWith("LINENO ")) {
                        hasLineNumber = true;
                    }
                    if (!hasLineNumber) {
                        if (node.getStartLine() == -1) {
                            sb.append("<!--LINENO file " + this.file + " line " + lt.getLines() + " -->");
                        } else {
                            sb.append("<!--LINENO file " + this.file + " line " + node.getStartLine() + " -->");
                        }
                    }
                }
                if (human_readable) {
                    sb.append('\n');
                }
                i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    this.write(child, sb, depth + 1, human_readable, lt);
                    ++i;
                }
                if (human_readable) {
                    i = 0;
                    while (i < depth) {
                        sb.append("  ");
                        ++i;
                    }
                }
                sb.append("</");
                sb.append(node.getNodeName());
                sb.append('>');
                if (!human_readable) break block41;
                sb.append('\n');
                break block41;
            }
            if (node.getNodeType() == Node.DOCUMENT_NODE) {
                i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    this.write(child, sb, depth, human_readable, lt);
                    ++i;
                }
            }
        }
    }

    class LineTracker {
        int index = 0;
        int lines = 1;
        StringBuffer sb;

        public LineTracker(StringBuffer sb) {
            this.sb = sb;
        }

        public int getLines() {
            while (this.index < this.sb.length()) {
                if (this.sb.charAt(this.index) == '\n') {
                    ++this.lines;
                }
                ++this.index;
            }
            return this.lines;
        }
    }
}

