/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.message;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageConstants;

public class Message
implements MessageConstants {
    int MINLEN = 10;
    private Object[] data;
    private int type = 0;
    private int length = 0;
    StringBuffer callstack = null;

    public void appendToCallStack(String s) {
        if (this.callstack == null) {
            this.callstack = new StringBuffer();
        }
        this.callstack.append(s);
    }

    public void appendToCallStack(Throwable t) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(bout));
        this.appendToCallStack(new String(bout.toByteArray()));
    }

    public Message() {
        this.data = new Object[this.MINLEN];
    }

    public Message(int type) {
        this.type = type;
        this.data = new Object[this.MINLEN];
    }

    public Message(Message m) {
        this.type = m.type;
        this.length = m.length;
        this.data = new Object[m.length];
        System.arraycopy(m.data, 0, this.data, 0, this.data.length);
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] instanceof Message) {
                this.data[i] = new Message((Message)this.data[i]);
            } else if (this.data[i] instanceof byte[]) {
                this.data[i] = ((byte[])this.data[i]).clone();
            }
            ++i;
        }
        if (m.callstack != null) {
            this.callstack = new StringBuffer(m.callstack.toString());
        }
    }

    private void add(Object o) {
        if (this.length == this.data.length) {
            Object[] ndata = new Object[(int)((double)this.data.length * 1.5) + 1];
            System.arraycopy(this.data, 0, ndata, 0, this.length);
            this.data = ndata;
        }
        this.data[this.length] = o;
    }

    private Object internal_remove(int index) {
        Object o = this.data[index];
        int i = index;
        while (i < this.length - 1) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        return o;
    }

    public void appendAll(Message message) {
        int i = 0;
        while (i < message.length) {
            this.add(message.data[i]);
            ++this.length;
            ++i;
        }
    }

    public void append(Message message) {
        this.add(message);
        ++this.length;
    }

    public void append(String string) {
        this.add(string);
        ++this.length;
    }

    public void append(int integer) {
        this.add(new Integer(integer));
        ++this.length;
    }

    public void append(Integer integer) {
        this.add(integer);
        ++this.length;
    }

    public void append(long longint) {
        this.add(new Long(longint));
        ++this.length;
    }

    public void append(Long longint) {
        this.add(longint);
        ++this.length;
    }

    public void append(double longfloat) {
        this.add(new Double(longfloat));
        ++this.length;
    }

    public void append(Double longfloat) {
        this.add(longfloat);
        ++this.length;
    }

    public void append(byte[] bytes) {
        this.add(bytes);
        ++this.length;
    }

    public void append(byte[] bytes, int off, int len) {
        byte[] b = new byte[len];
        System.arraycopy(bytes, off, b, 0, len);
        this.add(b);
        ++this.length;
    }

    public int getType(int i) {
        Object o = this.get(i);
        if (o == null) {
            return 0;
        }
        if (o instanceof String) {
            return 0;
        }
        if (o instanceof Integer) {
            return 1;
        }
        if (o instanceof Long) {
            return 2;
        }
        if (o instanceof Double) {
            return 3;
        }
        if (o instanceof Message) {
            return 4;
        }
        return 5;
    }

    public Object get(int i) {
        return this.data[i];
    }

    public Object remove(int index) {
        Object o = this.internal_remove(index);
        --this.length;
        return o;
    }

    public Object pop() {
        Object o = this.internal_remove(this.length - 1);
        --this.length;
        return o;
    }

    public void setType(int i) {
        this.type = i;
    }

    public int getType() {
        return this.type;
    }

    public int length() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Message) {
            return this.toString().equals(o.toString());
        }
        return super.equals(o);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message(");
        sb.append(this.type);
        sb.append(")");
        int i = 0;
        while (i < this.length) {
            Object o = this.data[i];
            sb.append("[");
            if (o == null) {
                sb.append("STR (null)");
            } else if (o instanceof String) {
                sb.append("STR,");
                sb.append(o);
            } else if (o instanceof Integer) {
                sb.append("INT,");
                sb.append(o);
            } else if (o instanceof Long) {
                sb.append("LONG,");
                sb.append(o);
            } else if (o instanceof Double) {
                sb.append("DOUBLE,");
                sb.append(o);
            } else if (o instanceof Message) {
                sb.append("SUBMSG,");
                sb.append(o);
            } else {
                sb.append("DATA,");
                sb.append(((byte[])o).length);
                sb.append(" bytes");
            }
            sb.append("]");
            ++i;
        }
        if (this.callstack != null) {
            sb.append("CALLSTACK," + this.callstack.toString());
        }
        return sb.toString();
    }

    public Object clone() {
        return new Message(this);
    }
}

