/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.util.HashMap;
import java.util.Random;

public class Cache {
    HashMap map = new HashMap();
    LinkedCacheList list = new LinkedCacheList();
    int MAX_SIZE = 50;
    double hits = 0.0;
    double misses = 0.0;

    public double getTotalRequests() {
        return this.hits + this.misses;
    }

    public double getTotalHits() {
        return this.hits;
    }

    public double getTotalMisses() {
        return this.misses;
    }

    public double getHitRatePercent() {
        return 100.0 * (this.hits / (this.hits + this.misses));
    }

    public Cache() {
    }

    public Cache(int max_size) {
        this.MAX_SIZE = max_size;
    }

    public void clear() {
        this.map = new HashMap();
        this.list = new LinkedCacheList();
    }

    public int size() {
        return this.map.size();
    }

    public void addToCache(Object key, Object value) {
        LinkedEntry e = (LinkedEntry)this.map.get(key);
        if (e == null) {
            this.map.put(key, this.list.add(key, value));
            if (this.map.size() > this.MAX_SIZE) {
                LinkedEntry rm = this.list.removeFirst();
                rm.next = null;
                rm.prev = null;
                if (rm != null) {
                    this.map.remove(rm.valueKey);
                }
            }
        }
    }

    public Object getFromCache(Object key) {
        LinkedEntry e = (LinkedEntry)this.map.get(key);
        if (e == null) {
            this.misses += 1.0;
            return null;
        }
        this.hits += 1.0;
        this.list.moveToFront(e);
        return e.valueValue;
    }

    public static void main(String[] args) throws Exception {
        Cache cache = new Cache(0);
        Random rand = new Random(5L);
        int hits = 0;
        int misses = 0;
        double COUNT = 2000000.0;
        double t = System.currentTimeMillis();
        int i = 0;
        while ((double)i < COUNT) {
            Integer key = new Integer(rand.nextInt(15));
            String value = (String)cache.getFromCache(key);
            if (value == null) {
                ++misses;
                value = "#" + key;
                cache.addToCache(key, value);
            } else {
                ++hits;
            }
            ++i;
        }
        t = (double)System.currentTimeMillis() - t;
        System.out.println(String.valueOf(hits) + " hits");
        System.out.println(String.valueOf(misses) + " misses");
        System.out.println("Cache size: " + cache.size());
        System.out.println(String.valueOf(COUNT) + " lookups in " + t + "ms");
        System.out.println(String.valueOf(t / COUNT) + " ms per lookups");
    }

    class LinkedCacheList {
        LinkedEntry start;
        LinkedEntry end;

        LinkedCacheList() {
        }

        public LinkedEntry add(Object key, Object value) {
            LinkedEntry e = new LinkedEntry();
            e.valueKey = key;
            e.valueValue = value;
            e.next = null;
            if (this.end == null) {
                this.start = e;
                this.end = e;
                e.prev = null;
            } else {
                this.end.next = e;
                e.prev = this.end;
                this.end = e;
            }
            return e;
        }

        public LinkedEntry removeFirst() {
            if (this.start != null) {
                if (this.start == this.end) {
                    this.end = null;
                }
                LinkedEntry ret = this.start;
                this.start = this.start.next;
                if (this.start != null) {
                    this.start.prev = null;
                }
                return ret;
            }
            return null;
        }

        public void moveToFront(LinkedEntry e) {
            if (e != this.end) {
                if (e == this.start) {
                    this.start = e.next;
                    this.start.prev = null;
                } else {
                    e.prev.next = e.next;
                    e.next.prev = e.prev;
                }
                this.end.next = e;
                e.prev = this.end;
                e.next = null;
                this.end = e;
            }
        }
    }

    class LinkedEntry {
        Object valueKey;
        Object valueValue;
        LinkedEntry prev;
        LinkedEntry next;

        LinkedEntry() {
        }

        public String toString() {
            return "" + this.valueKey;
        }
    }
}

