/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.publicapi.B2jConfig;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.prerun.PreRunService;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

public class B2jPlatform {
    private static ArrayList infolist = null;
    private static HashMap infos = null;

    public static Class loadClassFrom(String classname, String plugin) throws Exception {
        try {
            Class<?> c = Class.forName("org.eclipse.stp.b2j.core.publicapi.WorkbenchClassLoader");
            return (Class)c.getDeclaredMethod("loadClassFrom", String.class, String.class).invoke(null, classname, plugin);
        }
        catch (Exception exception) {
            return Class.forName(classname);
        }
    }

    public static Class loadClassFrom(String classname) throws Exception {
        try {
            Class<?> c = Class.forName("org.eclipse.stp.b2j.core.publicapi.WorkbenchClassLoader");
            return (Class)c.getDeclaredMethod("loadClassFrom", String.class).invoke(null, classname);
        }
        catch (Exception exception) {
            return Class.forName(classname);
        }
    }

    public static void startPreRunServices() {
        DependencyInfo[] dep = B2jPlatform.getAllDependencyInfo();
        int i = 0;
        while (i < dep.length) {
            Properties[] props = dep[i].getPreRunServices();
            int k = 0;
            while (k < props.length) {
                try {
                    PreRunService service = (PreRunService)B2jPlatform.loadClassFrom(props[k].getProperty("Class")).newInstance();
                    service.startService();
                }
                catch (Exception e) {
                    B2jPlugin.DBG.logVisibleError(e, "Failed to start up pre-run service: " + props[k].getProperty("Name"), false);
                }
                ++k;
            }
            ++i;
        }
    }

    private static Class getClass(String s) throws Exception {
        return Class.forName(s);
    }

    public static File getPlatformFolder() {
        File f = new File("./");
        try {
            Class C_B2jPlugin = B2jPlatform.getClass("org.eclipse.stp.b2j.core.B2jPlugin");
            Class C_Plugin = B2jPlatform.getClass("org.eclipse.core.runtime.Plugin");
            Class C_Platform = B2jPlatform.getClass("org.eclipse.core.runtime.Platform");
            Class C_Bundle = B2jPlatform.getClass("org.osgi.framework.Bundle");
            Class C_IPath = B2jPlatform.getClass("org.eclipse.core.runtime.IPath");
            Class C_Path = B2jPlatform.getClass("org.eclipse.core.runtime.Path");
            Object plugin = C_B2jPlugin.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            Object bundle = C_Plugin.getMethod("getBundle", new Class[0]).invoke(plugin, new Object[0]);
            Object path = C_Path.getConstructor(String.class).newInstance("./");
            Object ourl = C_Platform.getMethod("find", C_Bundle, C_IPath).invoke(null, bundle, path);
            URL url = (URL)C_Platform.getMethod("asLocalURL", URL.class).invoke(null, ourl);
            f = new File(url.getFile());
        }
        catch (Throwable throwable) {}
        f.mkdirs();
        return f;
    }

    public static File getDependenciesFolderFile() {
        return new File(String.valueOf(B2jPlatform.getPlatformFolder().getAbsolutePath()) + "/conf/");
    }

    public static String getDependenciesFolder() {
        return String.valueOf(B2jPlatform.getPlatformFolder().getAbsolutePath()) + "/conf/";
    }

    public static long getB2jConfigLastModified() {
        return new File(B2jPlatform.getPlatformFolder() + "/b2j.conf").lastModified();
    }

    public static B2jConfig getB2jConfig() {
        try {
            return new B2jConfig(new File(B2jPlatform.getPlatformFolder() + "/conf/Default/conf.xml"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void rereadDependencies(File f) throws Exception {
        infos = new HashMap();
        infolist = new ArrayList();
        B2jPlatform.readDependencies(f);
    }

    public static JARDependency[] toDependencyJARs(DependencyInfo[] info) {
        ArrayList<JARDependency> jars = new ArrayList<JARDependency>();
        int i = 0;
        while (i < info.length) {
            ArrayList list = info[i].resources;
            int k = 0;
            while (k < list.size()) {
                Properties props = (Properties)list.get(k);
                String s = props.getProperty("JAR");
                if (s != null) {
                    JARDependency jdep = new JARDependency(new byte[0], s);
                    jars.add(jdep);
                }
                ++k;
            }
            ++i;
        }
        JARDependency[] deps = new JARDependency[jars.size()];
        jars.toArray(deps);
        return deps;
    }

    public static DependencyInfo[] getEngineDependencyInfo() {
        DependencyInfo[] src = B2jPlatform.getAllDependencyInfo();
        ArrayList<DependencyInfo> filtered = new ArrayList<DependencyInfo>();
        int i = 0;
        while (i < src.length) {
            if (src[i].isEngineDependant()) {
                filtered.add(src[i]);
            }
            ++i;
        }
        DependencyInfo[] tmp = new DependencyInfo[filtered.size()];
        filtered.toArray(tmp);
        return tmp;
    }

    public static DependencyInfo[] getPortDependencyInfo() {
        DependencyInfo[] src = B2jPlatform.getAllDependencyInfo();
        ArrayList<DependencyInfo> filtered = new ArrayList<DependencyInfo>();
        int i = 0;
        while (i < src.length) {
            if (!src[i].isEngineDependant()) {
                filtered.add(src[i]);
            }
            ++i;
        }
        DependencyInfo[] tmp = new DependencyInfo[filtered.size()];
        filtered.toArray(tmp);
        return tmp;
    }

    public static DependencyInfo[] getAllDependencyInfo() {
        if (infos == null) {
            try {
                B2jPlatform.rereadDependencies(B2jPlatform.getDependenciesFolderFile());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DependencyInfo[] tmp = new DependencyInfo[infolist.size()];
        infolist.toArray(tmp);
        return tmp;
    }

    public static DependencyInfo getDependencyInfo(String ID2) {
        DependencyInfo[] infos = B2jPlatform.getAllDependencyInfo();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].ID.equals(ID2)) {
                return infos[i];
            }
            ++i;
        }
        return null;
    }

    private static void readDependencies(File f) throws Exception {
        File[] files = f.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                B2jPlatform.readDependencies(files[i]);
            } else if (files[i].getName().toLowerCase().equals("conf.xml")) {
                B2jPlatform.readDependencyInfo(files[i]);
            }
            ++i;
        }
    }

    private static void readDependencyInfo(File f) throws Exception {
        DocumentBuilder builder = XMLUtil.getDocumentBuilder();
        Document doc = builder.parse(new FileInputStream(f));
        Element elem = doc.getDocumentElement();
        if (elem.getTagName().equals("Dependencies")) {
            String ID2 = Util.getTextDirectlyUnder(Util.getFirstElement(elem, "ID"));
            String Version2 = Util.getTextDirectlyUnder(Util.getFirstElement(elem, "Version"));
            DependencyInfo info = new DependencyInfo(ID2, Version2, String.valueOf(f.getParentFile().getCanonicalPath()) + File.separatorChar);
            B2jPlatform.readProperties(elem, info.resources, "Resources");
            B2jPlatform.readProperties(elem, info.wsdlbindings, "WSDLBindings");
            B2jPlatform.readProperties(elem, info.wsdlresolvers, "WSDLResolvers");
            B2jPlatform.readProperties(elem, info.portdependencies, "PortDependencies");
            B2jPlatform.readProperties(elem, info.sessiontransports, "SessionTransports");
            B2jPlatform.readProperties(elem, info.prerunservices, "PreRunServices");
            B2jPlatform.readProperties(elem, info.autojavaports, "AutoJavaPorts");
            DependencyInfo old = (DependencyInfo)infos.get(ID2);
            if (old != null) {
                if (old.olderThan(info)) {
                    infos.put(ID2, info);
                    infolist.remove(old);
                    infolist.add(info);
                }
            } else {
                infos.put(ID2, info);
                infolist.add(info);
            }
        }
    }

    private static void readProperties(Element root, ArrayList list, String listName) {
        Element listRoots = Util.getFirstElement(root, listName);
        if (listRoots != null) {
            ArrayList lists = Util.getAllElements(listRoots);
            int k = 0;
            while (k < lists.size()) {
                Element e = (Element)lists.get(k);
                Properties props = new Properties();
                ArrayList elems = Util.getAllElements(e);
                int i = 0;
                while (i < elems.size()) {
                    Element prop = (Element)elems.get(i);
                    props.put(prop.getTagName(), Util.getTextDirectlyUnder(prop));
                    ++i;
                }
                list.add(props);
                ++k;
            }
        }
    }
}

