/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.example;

import java.io.File;
import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;
import org.eclipse.stp.b2j.core.publicapi.engine.IndependantBPELEngine;
import org.eclipse.stp.b2j.core.publicapi.program.IndependantBPELProgram;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class IndependantAPIExample {
    private static void runLocalBpelProgram(File bpel_src_file) throws Exception {
        IndependantBPELProgram program = new IndependantBPELProgram(bpel_src_file);
        IndependantBPELEngine engine = new IndependantBPELEngine(program);
        engine.runProgram(new PrintoutEngineListener(), false, true, true, true);
        engine.waitForProgramCompletion();
    }

    private static void runDistributedBpelProgram(File bpel_src_file, String[] hosts) throws Exception {
        IndependantBPELProgram program = new IndependantBPELProgram(bpel_src_file);
        SessionAddress coord_daemon_address = new SessionAddress("localhost", -1, -1, hosts[0], -1, -1);
        coord_daemon_address.setRequiresEncryption(false);
        coord_daemon_address.setRequiresPassword(false);
        SessionAddress coord_address = new SessionAddress("localhost", -1, -1, hosts[0], -1, -1);
        program.setCoordinatorHost(coord_daemon_address, coord_address);
        int i = 0;
        while (i < hosts.length) {
            SessionAddress worker_daemon_address = new SessionAddress("localhost", -1, -1, hosts[i], -1, -1);
            worker_daemon_address.setRequiresEncryption(false);
            worker_daemon_address.setRequiresPassword(false);
            SessionAddress worker_address = new SessionAddress("localhost", -1, -1, hosts[i], -1, -1);
            program.addWorkerHost(worker_daemon_address, worker_address);
            ++i;
        }
        IndependantBPELEngine engine = new IndependantBPELEngine(program);
        engine.runProgram(new PrintoutEngineListener(), false, true, true, true);
        engine.waitForProgramCompletion();
    }

    public static void main(String[] args) throws Exception {
        IndependantAPIExample.runLocalBpelProgram(new File(args[0]));
    }

    private static class PrintoutEngineListener
    implements BPELEngineListener {
        private PrintoutEngineListener() {
        }

        public void printInfo(String s) {
            System.out.println("INFO: " + s);
        }

        public void printDebug(String s) {
            System.out.println("DEBUG: " + s);
        }

        public void printEngineInfo(String s) {
            System.out.println("ENGINE_INFO: " + s);
        }

        public void printEngineDebug(String s) {
            System.out.println("ENGINE_DEBUG: " + s);
        }
    }
}

