/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.ArrayList;
import java.util.HashMap;

public class LockModelEquivalenceOptimiser implements LockModelOptimiser {
	
	HashMap refCache = new HashMap();
	
	public void optimise(LockModel model) {
		LockObject root = model.getRoot();
		ArrayList locks = root.getDeepLockList();
		ArrayList syncLists = new ArrayList();
		
		for (int i = 0; i < locks.size(); i++) {
			LockLock lock = (LockLock)locks.get(i);
			
			if (lock.isEnabled()) {
				//are there any other locks that are supersets of this lock
				
				//get all the Syncs referencing this lock
				ArrayList syncs = new ArrayList();
				
				getAllReferences(lock.getParent(), lock.getName(), syncs, false);
				
				syncLists.add(syncs);
				
				System.out.print("LOCK "+lock);
				for (int k = 0; k < syncs.size(); k++) {
					System.out.print(" SYNC "+syncs.get(k));
				}
				System.out.println("");
			} else {
				locks.remove(i--);
			}
		}
		
		//sort the list of locks based on the total length of time they synchronize for (the size of the sync list?)
		
		for (int i = 0; i < locks.size(); i++) {
			LockLock lock = (LockLock)locks.get(i);
			ArrayList syncs = (ArrayList)syncLists.get(i);
			
			if (lock.isEnabled()) {
				//is this lock a superset of 
				for (int k = 0; k < locks.size(); k++) {
					if (i != k) {
						LockLock tlock = (LockLock)locks.get(k);
						ArrayList tsyncs = (ArrayList)syncLists.get(k);
						
						if (tlock.isEnabled()) {

							//is lock a superset of tlock?
							
							boolean failed = false;
							
							//for each sync in tlock, is there an encloding sync in lock?
							for (int tz = 0; tz < tsyncs.size(); tz++) {
								LockSync tsync = (LockSync)tsyncs.get(tz);
								
								boolean foundSuperLock = false;
								
								for (int lz = 0; lz < syncs.size(); lz++) {
									LockSync sync = (LockSync)syncs.get(lz);
									
									if (sync.from <= tsync.from && sync.to >= tsync.to) {
										foundSuperLock = true;
										break;
									}
								}
								
								if (!foundSuperLock) {
									failed = true;
									break;
								}
							}
							
							//if yes then set tlock to disabled
							if (!failed) {
								tlock.setEnabled(false,"syncs on lock "+lock.getName()+" comprise a superset");
							}
						}
					}
				}
			}
		}
		
	}
	
	private void getAllReferences(LockObject cur, String lockName, ArrayList syncs, boolean breakOnDuplicateLock) {
		
		//if we find a sub-lock of the same name, we can't reference the one in the parent scope
		if (breakOnDuplicateLock) {
			//only check this if we're checking children, so that we don't match the original lock
			if (cur.hasLock(lockName)) {
				System.out.println("HAS LOCK "+lockName);
				return;
			}
		}
		
		//do we reference this lock
		if (cur instanceof LockSync) {
			LockSync sync = (LockSync)cur;
			if (sync.getLockName().equals(lockName)) {
				syncs.add(sync);
			}
		} else {
			
			//check cache
//			refCache.get()
			
			//check children
			for (int i = 0; i < cur.size(); i++) {
				LockObject tmp = cur.getChild(i);
				getAllReferences(tmp,lockName,syncs,true);
			}
		}
	}
}