/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELFault;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedHashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedBarrier;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FStack;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

/**
 * 
 * @author amiguel
 * 
 * Probably obsolete.
 * 
 * Part of the generic runtime engine API, represents a single thread in 
 * the engine Program execution.  Contains APIs which can be used by the 
 * engine Program classes to set and fetch conceptual stack information (e.g.
 * BPEL activity stack information)
 */
public class Runner extends RunnerInterface {

	public static final int RUNNER_MAX_STACK  = 200;
	
	private FStack callstack = new FStack();
//	public ArrayList callstack = new ArrayList(20);
	public String stackname = null;
	int overStack = 0;
	
	public void ipushStack(String stackline) throws Exception {
		if (stackname == null) stackname = "  runner("+Long.toHexString(id)+")@"+getHost()+":";

		if (callstack.size() > RUNNER_MAX_STACK) {
			overStack++;
			
		} else {
			callstack.push(stackline);
//			callstack.add(stackline);
			
		}
	}
	public void ipushStack(Message stackinfo) throws Exception {
		
		if (callstack.size() > RUNNER_MAX_STACK) {
			overStack++;
			
		} else {
			callstack.push(stackinfo);
//			callstack.add(stackinfo);
		
		}
	}

	public void ipopStack() throws Exception {
		
		if (overStack > 0) {
			overStack--;
		} else {
			callstack.pop();
//			callstack.remove(r.callstack.size()-1);
		}
		
	}
	
	public static void pushStack(Message stackinfo) {
		Thread thread = Thread.currentThread();
		if (thread instanceof Runner) {
			try {
				Runner r = (Runner)thread;
				r.ipushStack(stackinfo);
			} catch (Exception e) {
				Logger.error("Error adding to runner callstack",e);
			}
		}
	}
	
	public static void pushStack(String stackline) {
		Thread thread = Thread.currentThread();
		if (thread instanceof Runner) {
			try {
				Runner r = (Runner)thread;
				r.ipushStack(stackline);
			} catch (Exception e) {
				Logger.error("Error adding to runner callstack",e);
			}
		}
	}
	
	public static void popStack() {
		Thread thread = Thread.currentThread();
		if (thread instanceof Runner) {
			Runner r = (Runner)thread;	
			try {
				r.ipopStack();
			} catch (Exception e) {
				Logger.error("Error removing from runner callstack",e);
			}
		}
	}
	
	public Message getStackContents() {
		Message m = new Message();
		for (int i = 0; i < callstack.size(); i++) {
			Object o = callstack.get(i);
			if (o instanceof String) {
				m.append((String)o);
			} else {
				m.append((Message)o);
			}
		}
		return m;
	}
	public void setStackContents(Message m) {
		callstack.clear();
		for (int i = 0; i < m.length(); i++) {
			callstack.push(m.get(i));
		}
	}
	
	public String getStack() {
		StringBuffer sb = new StringBuffer();

		if (this.isAlive()) {
			sb.append("runner "+program_instance.getClass().getName()+"."+real_method.getName()+" started (ALIVE)\n");
		} else {
			sb.append("runner "+program_instance.getClass().getName()+"."+real_method.getName()+" started (NOW DEAD)\n");
		}
		
		for (int i = 0; i < callstack.size(); i++) {	
			if (callstack.get(i) instanceof String) {
				sb.append(stackname);
				sb.append((String)callstack.get(i));
				if (i < callstack.size()-1) {
					sb.append("\n");
				}
			}
		}

		if (overStack > 0) {
			sb.append("\n(STACK TRACE MAXIMUM REACHED - "+overStack+" more stackframes)");
		}
		
		return sb.toString();
	}
		
private static final Class[] args = new Class[] {
	};
private static final Object[] oargs = new Object[] {
	};

	Object program_instance;
	Method real_method;
	Method init_method;
	SubControllerInterface parent;
	long id;
	
	public Runner(ThreadGroup group, String name, SubControllerInterface parent, long id, Class program, Object program_instance, String method) throws Exception {
		super(group,name);
		this.parent = parent;
		this.id = id;
		this.program_instance = program_instance;
		
		setFields();

		setMethod(method);	
		
		setPriority(Thread.MAX_PRIORITY);
	}

	public void setMethod(String method) throws Exception {
		getRealMethod(method);
	}	

	private void setFields() throws Exception {
		Class program = program_instance.getClass();
		Field runner = program.getDeclaredField("engine");
		runner.setAccessible(true); //just in case
		runner.set(program_instance,this);
	}
	
	private void getRealMethod(String method) throws Exception {
		Class program = program_instance.getClass();
		real_method = program.getDeclaredMethod(method,args);
		init_method = program.getDeclaredMethod("engine_init",new Class[0]);
	}

	public void run() {

		Thread th = Thread.currentThread();

		try {
			//run the instance of the program
			init_method.invoke(program_instance,new Object[0]);
		} catch (Throwable t) {
			Logger.error(th.getName()+" Program initialisation call failed",t);
		}
		
		try {
			//run the instance of the program
			real_method.invoke(program_instance,oargs);
		} catch (Throwable t) {
			String error = th.getName()+" failed\n"+getStack();
			if (t instanceof InvocationTargetException) {
				Throwable ul = ((InvocationTargetException)t).getTargetException();
				Logger.error(error,ul);
				
				if (ul instanceof BPELFault) {
					Logger.error(error,((BPELFault)ul).getUnderlyingThrowable());
				}
			} else {
				Logger.error(error,t);
			}
			try {
				parent.print("Runner died unexpectedly "+error);
			} catch (Exception e) {
			}
		}
		
		try {
			parent.notifyRunnerDeath(id,this);
		} catch (Throwable t) {
			Logger.error(th.getName()+" failed to notify controller of death",t);
		}
	}	

//////////////////////////////////////////////////////////////
// RUNNER INTERFACE METHODS
//////////////////////////////////////////////////////////////
	
  /**
   * Returns a stack trace for the Throwable (Exception)
   * @param t the Throwable (Exception) to get the stack trace for
   * @return a string representation of a stack trace for the Throwable
   */
  public String getStackTrace(Throwable t) {
	  ByteArrayOutputStream os = new ByteArrayOutputStream();
	  PrintStream ps = new PrintStream(os);   // printing destination
	  t.printStackTrace(ps);
	  return os.toString();
  }//end method

  public HashMap getEngineLocalStorageMap(String name) {
	  return parent.getEngineLocalStorageMap(name);
  }

  public ClassLoader getProgramClassLoader() {
  	return program_instance.getClass().getClassLoader();
  }
  
public String[] getVariablesArray() throws Exception {
	String[] variable_names = parent.getVariableNames();
	return variable_names;	
}

public ArrayList getVariablesList() throws Exception {
	String[] variable_names = parent.getVariableNames();
	ArrayList list = new ArrayList();
	for (int i = 0; i < variable_names.length; i++) {
		list.add(variable_names[i]);	
	}
	return list;	
}

public String getHost() throws Exception {
	return parent.getHost();
}

public String getClientHost() throws Exception {
	return parent.getClientHost();
}
	
String[] hosts_cache = null;
public String[] getHostsArray() throws Exception {
	//we cache this because it never changes
	if (hosts_cache == null) {
		hosts_cache = parent.getHosts();
	}	
	
	String[] hosts = new String[hosts_cache.length];	
	System.arraycopy(hosts_cache,0,hosts,0,hosts.length);
	
	return hosts;
}

public ArrayList getHostsList() throws Exception {
	if (hosts_cache == null) {
		hosts_cache = parent.getHosts();	
	}
	
	ArrayList hosts = new ArrayList();
	for (int i = 0; i < hosts_cache.length; i++) {
		hosts.add(hosts_cache[i]);	
	}

	return hosts;
}

public void joinRunner(Long rid) throws Exception {
//	parent.joinRunner(new Long(id),rid);
	parent.joinRunner(rid);
}

public Message sendAndReceiveMessage(String conversation, Message msg, String conversationReturn) throws Exception {
	return parent.sendAndReceiveMessage(conversation,msg,conversationReturn);
}

public Message sendAndReceiveMessage(String conversation, Message msg, String[] conversationReturns) throws Exception {
	Message m = new Message();
	for (int i = 0; i < conversationReturns.length; i++) {
		m.append(conversationReturns[i]);
	}
	return parent.sendAndReceiveMessage(conversation,msg,m);
}

public void sendMessage(String conversation, Message m) throws Exception {
	parent.sendMessage(conversation,m);
}

public  Message receiveMessage(String conversation) throws Exception {
	return parent.receiveMessage(conversation);
}
public  Message receiveMessage(String conversation, long timeoutMS) throws Exception {
	return parent.receiveMessage(conversation,timeoutMS);
}

public  Message receiveMessage(String[] conversations) throws Exception {
	Message m = new Message();
	for (int i = 0; i < conversations.length; i++) {
		m.append(conversations[i]);
	}
	return parent.receiveMessage(m);
}
public  Message receiveMessage(String[] conversations, long timeoutMS) throws Exception {
	Message m = new Message();
	for (int i = 0; i < conversations.length; i++) {
		m.append(conversations[i]);
	}
	return parent.receiveMessage(m,timeoutMS);
}

public Message launchRunner(int count, String method, int host_index) throws Exception {
	return parent.launchRunner(count,method,host_index);
} 

public Message launchRunner(int count, String method, int host_index, List args) throws Exception {
	return parent.launchRunner(count,method,host_index,args);
} 

public Message launchRunner(int count, String method, int host_index, Message args) throws Exception {
	return parent.launchRunner(count,method,host_index,args);
} 

public Message launchRunner(int count, String method, int host_index, String[] args) throws Exception {
	return parent.launchRunner(count,method,host_index,args);
} 

public ArrayList launchRunnerLocal(int count, String method) throws Exception {
	return parent.launchRunnerLocal(count,method, new ArrayList(1));	
} 

public ArrayList launchRunnerLocal(int count, String method, ArrayList args) throws Exception {
	return parent.launchRunnerLocal(count,method,args);	
} 

public Thread asyncProgramMethod(String method, ArrayList data) throws Exception {
	DataThread thread = new DataThread(program_instance,method,data);
	thread.start();
	return thread;
} 

public SharedBarrier newBarrier(String name, int size) throws Exception {
	return parent.newBarrier(name,size);	
}

public SharedMutex newMutex(String name) throws Exception {
	return parent.newMutex(name);	
}

public SharedSemaphore newSemaphore(String name, int initial) throws Exception {
	return parent.newSemaphore(name,initial);	
}

public SharedVariable newVariable(String name, int type, boolean dirty) throws Exception {
	return parent.newVariable(name,type,dirty);	
}

public SharedHashMap newHashMap(String name) throws Exception {
	return parent.newHashMap(name);	
}

public SharedSemaphore getSemaphore(String name) throws Exception {
	return parent.getSemaphore(name);	
}

public SharedBarrier getBarrier(String name) throws Exception {
	return parent.getBarrier(name);
}

public SharedMutex getMutex(String name) throws Exception {
	return parent.getMutex(name);
}

public SharedVariable getVariable(String name) throws Exception {
	return parent.getVariable(name);	
}

public SharedHashMap getHashMap(String name) throws Exception {
	return parent.getHashMap(name);	
}

public void trace(Message m) throws Exception {
	parent.trace(m);	
}

public void print(String msg) throws Exception {
	parent.print(msg);	
}

public void print(Object msg) throws Exception {
	parent.print(""+msg);	
}

public void debug(String msg) throws Exception {
	parent.debug(msg);	
}

public void debug(Object msg) throws Exception {
	parent.debug(""+msg);	
}

public long getRunnerId() {
	return id;
}

public String getRunnerIdHex() {	
	return ID.ID_HEX(id);
}

public long getClock() {
	return parent.getClock();	
}

public void terminate() throws Exception {
	parent.terminate();
}


}//end class