/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;

public class CookieCache {

	private static Object sdf_LOCK = new Object();
	private static SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z");
	
	ArrayList cookies = new ArrayList();
	
	public void addCookie(String name, String value, long expiryDate, String domain, String path, boolean secure) {
		Cookie cookie = new Cookie(name,value,expiryDate,domain,path,secure);
		//TODO could speed up cookie fetches with some sorting
		cookies.add(cookie);
	}
	
	public void addCookie(String unparsedCookie, String serverhost) {
		CharStack stack = new CharStack(unparsedCookie);

		String name = null;
		String cvalue = null;
		boolean secure = false;
		long expiryDate = Long.MAX_VALUE;
		String domain = serverhost;
		String path = null;
		
		boolean first = true;
		
		while (!stack.isEmpty()) {
			String pair = stack.popUntil(';',true);
//System.out.println(pair);
//try {
//	Thread.sleep(1000);
//} catch (Exception e) {
//}
			
			pair = pair.trim();
			
			int eqIndex = pair.indexOf('=');
			int scIndex = pair.indexOf(';');
			
			if (eqIndex != -1) {
				String key = pair.substring(0,eqIndex);
				String value;
				
				if (scIndex != -1) {
					value = pair.substring(eqIndex+1,scIndex);
				} else {
					value = pair.substring(eqIndex+1);
				}
				
				if (first) {
					first = false;

					name = key;
					cvalue = value;
					
					if (SOAPFactory.DEBUG) System.out.println("Cookie NAME:"+name);
					if (SOAPFactory.DEBUG) System.out.println("Cookie VALUE:"+cvalue);
					
				} else {
					if (key.equalsIgnoreCase("expires")) {
						try {
							synchronized(sdf_LOCK) {
								expiryDate = sdf.parse(value).getTime();
							}
						} catch (ParseException e) {
						}
						if (SOAPFactory.DEBUG) System.out.println("Cookie EXPIRES:"+value+" ("+new Date(expiryDate)+")");
						
					} else if (key.equalsIgnoreCase("domain")) {
						domain = value;
						if (SOAPFactory.DEBUG) System.out.println("Cookie DOMAIN:"+domain);
						
					} else if (key.equalsIgnoreCase("path")) {
						path = value;
						if (SOAPFactory.DEBUG) System.out.println("Cookie PATH:"+path);
						
					}
				}
				
			} else {
				if (pair.equalsIgnoreCase("secure")) {
					secure = true;
					if (SOAPFactory.DEBUG) System.out.println("Cookie SECURE");
				}
			}
			
		}
		
		if (name != null
			&& cvalue != null) {
			
			addCookie(name,cvalue,expiryDate,domain,path,secure);
		}
	}
	
	public String getCookies(String domain, String path, boolean secure) {
		StringBuffer sb = new StringBuffer();
		
		//TODO cookie should be sorted by domain and path so that the most relevant cookies are transmitted first
		
		for (int i = 0; i < cookies.size(); i++) {
			Cookie cookie = (Cookie)cookies.get(i);
			
			if (System.currentTimeMillis() > cookie.expiryDate) {
				//expired
				cookies.remove(i--);
				
			} else if (!cookie.secure || (secure == cookie.secure)) {
				//no security problems
				
				if (domain.endsWith(cookie.domain)) {
					//domain match
					
					if (path.startsWith(cookie.path)) {
						//path match
						
						if (sb.length() > 0) {
							sb.append("; ");
						}
						sb.append(cookie.name);
						sb.append("=");
						sb.append(cookie.value);
					}
				}
			}
		}

		if (SOAPFactory.DEBUG) System.out.println("Cookie to send:"+sb);
		
		return sb.toString();
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < cookies.size(); i++) {
			Cookie cookie = (Cookie)cookies.get(i);
			sb.append("Cookie: "+cookie.name+"="+cookie.value+" (path="+cookie.path+") (domain="+cookie.domain+") (secure="+cookie.secure+")");
		}
		return sb.toString();
	}
	
	private class Cookie {
		String name;
		String value;
		long expiryDate = Long.MAX_VALUE;
		String domain;
		String path;
		boolean secure;
		
		public Cookie(String name, String value, long expiryDate, String domain, String path, boolean secure) {
			this.domain = domain;
			this.expiryDate = expiryDate;
			this.name = name;
			this.path = path;
			this.secure = secure;
			this.value = value;
		}
	}
}